/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.internal;

import com.dbeaver.ee.qm.QMEventListener;
import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qm.db.impl.QMEmbeddedService;
import com.dbeaver.model.DBPApplicationExtended;
import com.dbeaver.model.QMService;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPersistent;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.registry.BaseApplicationImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IPluginService;

public class QMPluginService
implements IPluginService {
    private static final Log log = Log.getLog(QMPluginService.class);
    private static final String QM_SERVICE_TYPE_SYSTEM_PROPERTY = "dbeaver.qm.service.type";
    private static QMService qmService;
    private QMEventListener qmHandler;

    public static QMService getQmService() {
        return qmService;
    }

    public void activateService() {
        if (!this.initQMService()) {
            return;
        }
        if (DBWorkbench.getPlatform().getApplication().isPrimaryInstance()) {
            this.qmHandler = new QMEventListener();
            QMUtils.registerMetaListener((QMMetaListener)this.qmHandler);
        }
    }

    private boolean initQMService() {
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        qmService = application instanceof DBPApplicationExtended ? ((DBPApplicationExtended)application).getQueryManagerService() : new QMEmbeddedService();
        try {
            LoggingProgressMonitor monitor = new LoggingProgressMonitor();
            this.initGlobalQMSession((DBRProgressMonitor)monitor);
        }
        catch (DBException e) {
            log.error((Object)"Failed to initialize query manager", (Throwable)e);
            return false;
        }
        return true;
    }

    private void initGlobalQMSession(DBRProgressMonitor monitor) throws DBException {
        if (BaseApplicationImpl.getInstance().isMultiuser()) {
            return;
        }
        SMSession session = this.getSpaceSession(monitor);
        SMSessionPersistent sessionPersistent = (SMSessionPersistent)DBUtils.getAdapter(SMSessionPersistent.class, (Object)session);
        if (sessionPersistent == null) {
            throw new DBException("Session persistent not found");
        }
        SMSessionPrincipal globalPrincipal = session.getSessionPrincipal();
        String userName = globalPrincipal.getUserName();
        String qmSessionId = qmService.openSession(monitor, new QMSessionInfo(userName, globalPrincipal.getUserDomain()));
        sessionPersistent.setAttribute("qm_session_id", (Object)qmSessionId);
    }

    private SMSession getSpaceSession(DBRProgressMonitor monitor) throws DBException {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        SMSession workspaceSession = workspace.getAuthContext().getSpaceSession(monitor, (SMAuthSpace)workspace, false);
        if (workspaceSession == null) {
            throw new DBException("No workspace session");
        }
        return workspaceSession;
    }

    public void deactivateService() {
        if (this.qmHandler != null) {
            this.qmHandler.dispose();
            QMUtils.unregisterMetaListener((QMMetaListener)this.qmHandler);
        }
        QMDBModel.shutdown();
    }

    private static enum QMServiceTypes {
        EMBEDDED;

    }
}

