/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.QMConfigurationProviderEE;
import com.dbeaver.ee.qm.db.QMDBDataSourceProvider;
import com.dbeaver.ee.qm.db.impl.EmbeddedDatabase;
import com.dbeaver.ee.qm.db.model.QMDBQueryFilter;
import com.dbeaver.ee.qm.db.model.QMDBQueryRecord;
import com.dbeaver.ee.qm.internal.QMActivator;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.sql.schema.ClassLoaderScriptSource;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaManager;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaScriptSource;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaVersionManager;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class QMDBModel {
    private static final Log log = Log.getLog(QMDBModel.class);
    public static final String DATABASE_DEFAULT_DRIVER = "h2_embedded";
    public static final String DATABASE_DEFAULT_DRIVER_CLASS = "org.h2.Driver";
    public static final String DATABASE_DEFAULT_URL = "jdbc:h2:${workspace}/.metadata/qmdb/qmdb";
    public static final String EMBEDDED_DATABASE_ID = "qmdb";
    private static QMDBModel instance;
    private String schemaName;
    private Long deployId;
    private Long productVersionId;
    private Long workspaceId;
    private Long hostId;
    private Long runId;
    private int appPortNumber = 0;
    private Connection dbConnection;
    private SQLDialect databaseDialect;
    private EmbeddedDatabase embeddedDatabase;

    public static synchronized QMDBModel getInstance() {
        if (instance == null) {
            instance = new QMDBModel();
        }
        return instance;
    }

    public static void shutdown() {
        if (instance != null) {
            instance.shutdownModel();
            instance = null;
        }
    }

    public QMDBModel() {
        this.openConnection();
        if (this.getConnection() != null) {
            try {
                DatabaseMetaData metaData = this.getConnection().getMetaData();
                this.initializeSchema();
                String dbName = metaData.getDatabaseProductName();
                String dbVersion = metaData.getDatabaseProductVersion();
                log.debug((Object)("\tQMDB server started (" + dbName + " " + dbVersion + ")"));
            }
            catch (Exception e) {
                log.error((Object)"Error initializing QM database schema", (Throwable)e);
                this.closeConnection();
            }
        }
    }

    public boolean isInitialized() {
        return this.dbConnection != null;
    }

    Long getRunId() {
        return this.runId;
    }

    Long getWorkspaceId() {
        return this.workspaceId;
    }

    public EmbeddedDatabase getEmbeddedDatabase() {
        return this.embeddedDatabase;
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    private void openConnection() {
        block15: {
            if (this.dbConnection == null && !DBWorkbench.getPlatform().getApplication().isExclusiveMode()) {
                log.debug((Object)"Initialize QMDB...");
                LoggingProgressMonitor monitor = new LoggingProgressMonitor(log);
                String driverID = DATABASE_DEFAULT_DRIVER;
                String conURL = DATABASE_DEFAULT_URL;
                Properties conProperties = new Properties();
                QMConfigurationProviderEE qmConfigurationProvider = (QMConfigurationProviderEE)DBUtils.getAdapter(QMConfigurationProviderEE.class, (Object)DBWorkbench.getPlatform().getApplication());
                if (qmConfigurationProvider != null) {
                    driverID = qmConfigurationProvider.getDriverID();
                    conURL = qmConfigurationProvider.getConnectionURL();
                    conProperties = qmConfigurationProvider.getConnectionProperties();
                }
                boolean isEmbeddedDB = conURL.equals(DATABASE_DEFAULT_URL);
                conURL = GeneralUtils.replaceVariables((String)conURL, (IVariableResolver)new SystemVariablesResolver());
                try {
                    block14: {
                        Driver driverInstance;
                        DBPDriver driver = DataSourceProviderRegistry.getInstance().findDriver(driverID);
                        if (driver == null) {
                            throw new DBException("QMDB driver '" + driverID + "' not found");
                        }
                        driver = driver.createOriginalCopy();
                        this.databaseDialect = driver.getScriptDialect().createInstance();
                        if (driver.needsExternalDependencies()) {
                            log.debug((Object)("JDBC  dependencies are missing for driver " + driver.getFullName() + ". Fallback to default H2 driver."));
                            try {
                                driverInstance = (Driver)Class.forName(DATABASE_DEFAULT_DRIVER_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (Throwable e) {
                                log.error((Object)"Can't load QMDB database driver", e);
                                return;
                            }
                        } else {
                            driverInstance = (Driver)driver.getDriverInstance((DBRProgressMonitor)monitor);
                        }
                        try {
                            this.dbConnection = driverInstance.connect(conURL, conProperties);
                        }
                        catch (Exception e) {
                            log.debug((Object)"Error opening QMDB database", (Throwable)e);
                            if (!isEmbeddedDB) break block14;
                            this.tryDatabaseRecover(driverInstance, conURL, conProperties, e);
                        }
                    }
                    if (this.dbConnection == null) break block15;
                    try {
                        this.dbConnection.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error setting auto-commit state", (Throwable)e);
                    }
                    if (isEmbeddedDB) {
                        Path dbPath = QMDBModel.getEmbeddedDatabasePath();
                        this.embeddedDatabase = new EmbeddedDatabase(EMBEDDED_DATABASE_ID, dbPath, this.dbConnection);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Can't start QM embedded database", (Throwable)e);
                }
            }
        }
    }

    @NotNull
    private static Path getEmbeddedDatabasePath() {
        return DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(EMBEDDED_DATABASE_ID);
    }

    private void tryDatabaseRecover(Driver driverInstance, String conURL, Properties conProperties, Exception dbError) {
        String sqlState;
        boolean internalH2Error = false;
        if (dbError instanceof SQLException && ("90030".equals(sqlState = ((SQLException)dbError).getSQLState()) || SQLState.SQL_HY000.getCode().equals(sqlState))) {
            internalH2Error = true;
        }
        if (!internalH2Error) {
            return;
        }
        Path edbPath = QMDBModel.getEmbeddedDatabasePath();
        if (!Files.exists(edbPath, new LinkOption[0])) {
            return;
        }
        Path backupPath = QMDBModel.getEmbeddedDatabasePath().getParent().resolve("qmdb-backup-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis())));
        if (Files.exists(backupPath, new LinkOption[0])) {
            log.error((Object)("Backup directory '" + backupPath + "' already exists. Can't backup again."));
            return;
        }
        try {
            Files.move(edbPath, backupPath, new CopyOption[0]);
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        log.warn((Object)"Corrupted QMDB database was archived. Creating new empty QMDB database..");
        try {
            this.dbConnection = driverInstance.connect(conURL, conProperties);
        }
        catch (Exception e) {
            log.error((Object)"Can't create QMDB database after backup", (Throwable)e);
            return;
        }
    }

    private void shutdownModel() {
        try {
            this.endCurrentRun();
        }
        catch (SQLException e) {
            log.warn((Object)e);
        }
        if (this.isInitialized()) {
            log.debug((Object)"Closing QMDB connection.");
            this.closeConnection();
            log.debug((Object)"QMDB stopped.");
        }
    }

    private void closeConnection() {
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (Exception e) {
                log.warn((Object)"Error while stopping QM embedded database", (Throwable)e);
            }
            this.dbConnection = null;
        }
    }

    public void initializeSchema() throws DBException, SQLException, IOException {
        this.schemaName = QMActivator.getDefault().getPreferences().getString("qmdb.database.schema");
        if (CommonUtils.isEmptyTrimmed((String)this.schemaName)) {
            this.schemaName = null;
        }
        if (this.dbConnection != null) {
            this.schemaName = null;
        }
        if (this.getConnection() == null) {
            log.error((Object)"No QMDB connection");
            return;
        }
        LoggingProgressMonitor monitor = new LoggingProgressMonitor();
        SQLSchemaManager schemaManager = new SQLSchemaManager("QMDB", (SQLSchemaScriptSource)new ClassLoaderScriptSource(QMDBDataSourceProvider.class.getClassLoader(), "ddl/qm_schema.sql", "ddl/qm_schema_update_"), monitor1 -> this.getConnection(), (SQLSchemaVersionManager)new QMSchemaVersionManager(), this.databaseDialect, null, 13, 3);
        schemaManager.updateSchema((DBRProgressMonitor)monitor);
        this.checkVersionConsistency();
        log.debug((Object)"\tCheck QMDB deployment");
        this.checkDBeaverHost();
        this.checkDBeaverDeployment();
        this.checkDBeaverVersion();
        long systemUserId = this.checkDBeaverSystemUser((DBRProgressMonitor)monitor);
        this.workspaceId = this.checkDBeaverPlatformWorkspace();
        this.runId = this.createDBeaverRun(this.workspaceId, systemUserId);
    }

    private long checkDBeaverSystemUser(DBRProgressMonitor monitor) throws DBException, SQLException {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        SMSession workspaceSession = workspace.getAuthContext().getSpaceSession(monitor, (SMAuthSpace)workspace, true);
        if (workspaceSession == null) {
            throw new DBException("No workspace session");
        }
        SMSessionPrincipal globalPrincipal = workspaceSession.getSessionPrincipal();
        return this.findOrCreateUser(globalPrincipal);
    }

    private long checkDBeaverPlatformWorkspace() throws SQLException {
        String workspacePath = Platform.getInstanceLocation().getURL().toString();
        return this.findOrCreateQMDBeaverWorkspace(workspacePath);
    }

    private void checkVersionConsistency() {
    }

    public String getTableName(String name) {
        if (this.schemaName == null) {
            return name;
        }
        return String.valueOf(this.schemaName) + "." + name;
    }

    private void checkDBeaverDeployment() throws SQLException {
        String installPath = CommonUtils.truncateString((String)Platform.getInstallLocation().getURL().toString(), (int)1000);
        this.deployId = JDBCUtils.queryLong((Connection)this.getConnection(), (String)("SELECT DEPLOY_ID FROM " + this.getTableName("QM_DBEAVER_DEPLOYMENT") + " WHERE HOST_ID=? AND INSTALL_PATH=?"), (Object[])new Object[]{this.hostId, installPath});
        if (this.deployId == null) {
            this.deployId = JDBCUtils.executeInsertAutoIncrement((Connection)this.getConnection(), (String)("INSERT INTO " + this.getTableName("QM_DBEAVER_DEPLOYMENT") + " (HOST_ID,INSTALL_PATH,PORT_NUMBER,UPDATE_TIME) VALUES(?,?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{this.hostId, installPath, this.appPortNumber});
        }
    }

    private void checkDBeaverVersion() throws SQLException {
        String productName = GeneralUtils.getProductName();
        String versionName = GeneralUtils.getProductVersion().toString();
        this.productVersionId = JDBCUtils.queryLong((Connection)this.getConnection(), (String)("SELECT VERSION_ID FROM " + this.getTableName("QM_DBEAVER_VERSION") + " WHERE PRODUCT_NAME=? AND VERSION_NAME=?"), (Object[])new Object[]{productName, versionName});
        if (this.productVersionId == null) {
            this.productVersionId = JDBCUtils.executeInsertAutoIncrement((Connection)this.getConnection(), (String)("INSERT INTO " + this.getTableName("QM_DBEAVER_VERSION") + " (PRODUCT_NAME,VERSION_NAME,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{productName, versionName});
        }
    }

    long findOrCreateQMDBeaverWorkspace(String workspacePath) throws SQLException {
        Long workspaceId = this.findQMDBeaverWorkspace(workspacePath);
        if (workspaceId == null) {
            workspaceId = JDBCUtils.executeInsertAutoIncrement((Connection)this.getConnection(), (String)("INSERT INTO " + this.getTableName("QM_DBEAVER_WORKSPACE") + " (HOST_ID,WORKSPACE_PATH,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{this.hostId, workspacePath});
        }
        return workspaceId;
    }

    public Long findOrCreateQMDBeaverProject(UUID uuid, String projectName, String projectPath, boolean isAnonymous) throws SQLException, DBException {
        Long projectId = JDBCUtils.queryLong((Connection)this.getConnection(), (String)("SELECT PROJECT_ID FROM " + this.getTableName("QM_DBEAVER_PROJECT") + " WHERE PROJECT_NAME=? AND WORKSPACE_ID=?"), (Object[])new Object[]{projectName, this.workspaceId});
        if (projectId == null) {
            projectId = JDBCUtils.executeInsertAutoIncrement((Connection)this.getConnection(), (String)("INSERT INTO " + this.getTableName("QM_DBEAVER_PROJECT") + "(PROJECT_NAME,PROJECT_UUID,PROJECT_PATH,IS_ANONYMOUS,WORKSPACE_ID,UPDATE_TIME) VALUES(?,?,?,?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{projectName, uuid, projectPath, isAnonymous, this.workspaceId});
        }
        return projectId;
    }

    Long findQMDBeaverWorkspace(String workspacePath) throws SQLException {
        return JDBCUtils.queryLong((Connection)this.getConnection(), (String)("SELECT WORKSPACE_ID FROM " + this.getTableName("QM_DBEAVER_WORKSPACE") + " WHERE HOST_ID=? AND WORKSPACE_PATH=?"), (Object[])new Object[]{this.hostId, workspacePath});
    }

    Long findOrCreateUser(SMSessionPrincipal globalPrincipal) throws SQLException {
        String osUserName = globalPrincipal.getUserName();
        String osDomainName = globalPrincipal.getUserDomain();
        return this.findOrCreateUser(osUserName, osDomainName);
    }

    Long findOrCreateUser(String userName, String userDomain) throws SQLException {
        Long userId = JDBCUtils.queryLong((Connection)this.getConnection(), (String)("SELECT USER_ID FROM " + this.getTableName("QM_USER") + " WHERE DOMAIN_NAME=? AND USER_NAME=?"), (Object[])new Object[]{CommonUtils.notEmpty((String)userDomain), userName});
        if (userId == null) {
            userId = JDBCUtils.executeInsertAutoIncrement((Connection)this.getConnection(), (String)("INSERT INTO " + this.getTableName("QM_USER") + " (DOMAIN_NAME,USER_NAME,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{CommonUtils.notEmpty((String)userDomain), userName});
        }
        return userId;
    }

    private void checkDBeaverHost() throws SQLException, IOException {
        InetAddress localHost = InetAddress.getLocalHost();
        String hostName = localHost.getHostName();
        String hostIP = localHost.getHostAddress();
        byte[] hardwareAddress = RuntimeUtils.getLocalMacAddress();
        String macAddress = CommonUtils.toHexString((byte[])hardwareAddress);
        this.hostId = JDBCUtils.queryLong((Connection)this.getConnection(), (String)("SELECT HOST_ID FROM " + this.getTableName("QM_DBEAVER_HOST") + " WHERE MAC_ADDRESS=?"), (Object[])new Object[]{macAddress});
        if (this.hostId == null) {
            this.hostId = JDBCUtils.executeInsertAutoIncrement((Connection)this.getConnection(), (String)("INSERT INTO " + this.getTableName("QM_DBEAVER_HOST") + " (MAC_ADDRESS,HOST_NAME,IP_ADDRESS,UPDATE_TIME) VALUES(?,?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{macAddress, hostName, hostIP});
        }
    }

    long createDBeaverRun(long workspaceId, long workspaceUserId) throws SQLException {
        return JDBCUtils.executeInsertAutoIncrement((Connection)this.getConnection(), (String)("INSERT INTO " + this.getTableName("QM_DBEAVER_RUN") + " (DEPLOY_ID,VERSION_ID,WORKSPACE_ID,USER_ID,START_TIME) VALUES(?,?,?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{this.deployId, this.productVersionId, workspaceId, workspaceUserId});
    }

    private void endCurrentRun() throws SQLException {
        if (this.getConnection() == null) {
            return;
        }
        JDBCUtils.executeSQL((Connection)this.getConnection(), (String)("UPDATE " + this.getTableName("QM_DBEAVER_RUN") + " SET STOP_TIME=CURRENT_TIMESTAMP WHERE RUN_ID=?"), (Object[])new Object[]{this.runId});
    }

    public List<QMDBQueryRecord> searchQueryHistory(DBRProgressMonitor monitor, QMDBQueryFilter filter) throws DBException {
        if (this.getConnection() == null) {
            return new ArrayList<QMDBQueryRecord>();
        }
        ArrayList<QMDBQueryRecord> results = new ArrayList<QMDBQueryRecord>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT q.QUERY_ID,q.QUERY_TEXT,s.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,c.DATASOURCE_ID,c.INSTANCE_ID,c.CONTEXT_NAME\nFROM ").append(this.getTableName("QM_QUERY")).append(" q, ").append(this.getTableName("QM_STATEMENT")).append(" s, ").append(this.getTableName("QM_EVENT")).append(" e, ").append(this.getTableName("QM_CONNECTION")).append(" c ");
        sql.append("\nWHERE q.QUERY_ID=s.QUERY_ID AND e.EVENT_ID=s.STATEMENT_ID AND c.CONNECTION_ID=e.CONNECTION_ID");
        if (!CommonUtils.isEmpty((String)filter.getQueryText())) {
            sql.append("\nAND q.QUERY_TEXT LIKE ?");
        }
        if (filter.getRowOffset() > 0 || filter.getMaxRows() > 0) {
            sql.append("\nLIMIT ").append(filter.getRowOffset()).append(", ").append(filter.getMaxRows());
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PreparedStatement dbStat = this.getConnection().prepareStatement(sql.toString());){
                int paramIndex = 1;
                if (!CommonUtils.isEmpty((String)filter.getQueryText())) {
                    dbStat.setString(paramIndex++, "%" + filter.getQueryText() + "%");
                }
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (ResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        QMDBQueryRecord record = new QMDBQueryRecord();
                        record.setQueryId(dbResult.getLong("QUERY_ID"));
                        record.setQueryText(dbResult.getString("QUERY_TEXT"));
                        record.setStatementPurpose(dbResult.getInt("STATEMENT_PURPOSE"));
                        record.setErrorCode(dbResult.getLong("ERROR_CODE"));
                        record.setErrorMessage(dbResult.getString("ERROR_MESSAGE"));
                        record.setExecuteTime(dbResult.getLong("EXECUTE_TIME"));
                        record.setFetchTime(dbResult.getLong("FETCH_TIME"));
                        results.add(record);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error reading query history", (Throwable)e);
        }
        return results;
    }

    void stopDatabase() {
        this.closeConnection();
    }

    Connection restartDatabase() {
        this.openConnection();
        return this.dbConnection;
    }

    private static class QMSchemaVersionManager
    implements SQLSchemaVersionManager {
        private QMSchemaVersionManager() {
        }

        public int getCurrentSchemaVersion(DBRProgressMonitor monitor, Connection connection, String schemaName) throws DBException, SQLException {
            try {
                Object version = JDBCUtils.executeQuery((Connection)connection, (String)("SELECT VERSION FROM " + this.getInfoTableName(schemaName)), (Object[])new Object[0]);
                return CommonUtils.toInt((Object)version);
            }
            catch (SQLException sQLException) {
                return -1;
            }
        }

        public int getLatestSchemaVersion() {
            return 13;
        }

        public void updateCurrentSchemaVersion(DBRProgressMonitor monitor, @NotNull Connection connection, @NotNull String schemaName, int version) throws DBException, SQLException {
            int updateCount = JDBCUtils.executeUpdate((Connection)connection, (String)("UPDATE " + this.getInfoTableName(schemaName) + " SET VERSION=?,UPDATE_TIME=CURRENT_TIMESTAMP"), (Object[])new Object[]{version});
            if (updateCount <= 0) {
                JDBCUtils.executeSQL((Connection)connection, (String)("INSERT INTO " + this.getInfoTableName(schemaName) + " (VERSION,UPDATE_TIME) VALUES(?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{version});
            }
        }

        private String getInfoTableName(String schemaName) {
            if (schemaName == null) {
                return "QM_INFO";
            }
            return String.valueOf(schemaName) + "." + "QM_INFO";
        }
    }
}

