/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.externaltable;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.netezza.core.Encoding;
import org.netezza.core.NzConstants;
import org.netezza.externaltable.Loader;
import org.netezza.sql.NzConnection;

public class NzLoad
implements Loader {
    private NzConnection connection;
    private boolean reading;
    private int blockSize;
    private byte[] blockBuffer;
    private InputStream stream;
    private int loadStatus;
    private final String logExt = ".nzlog";
    private final String badExt = ".nzbad";

    public NzLoad(NzConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean setUp() throws SQLException {
        String method = "setUpLoad";
        this.connection.LOGGER.entry(this.getClass(), method);
        int clientVersion = 1;
        try {
            String fileName = this.connection.receiveString();
            this.connection.LOGGER.debug(this.getClass(), method, "FILE: " + fileName);
            int hostVersion = this.connection.receiveIntR(4);
            this.connection.LOGGER.debug(this.getClass(), method, "HOST VERSION: " + hostVersion);
            this.connection.LOGGER.debug(this.getClass(), method, "CLIENT VERSION: " + clientVersion);
            this.connection.sendInt(clientVersion, 4);
            this.connection.flush();
            int format = this.connection.receiveIntR(4);
            this.connection.LOGGER.debug(this.getClass(), method, "FORMAT: " + format);
            this.blockSize = this.connection.receiveIntR(4);
            this.connection.LOGGER.debug(this.getClass(), method, "BLOCK SIZE: " + this.blockSize);
            if (this.blockSize <= 0) {
                throw new SQLException("Remote external table transfer error : Invalid block Size :" + this.blockSize);
            }
            this.blockBuffer = new byte[this.blockSize];
            this.stream = new BufferedInputStream(new FileInputStream(fileName), this.blockSize);
            this.loadStatus = 1;
            this.reading = true;
            this.connection.loading = true;
            this.connection.stopLoading = false;
        }
        catch (IOException e) {
            this.cleanUpLoad();
            this.connection.LOGGER.exit(this.getClass(), method, false);
            return false;
        }
        this.connection.LOGGER.exit(this.getClass(), method, true);
        return true;
    }

    @Override
    public void processLogs(String logDir, String fileName, int logType) throws SQLException {
        StringBuffer fullpath = new StringBuffer();
        int numBytes = 0;
        byte[] databuffer = new byte[65536];
        FileWriter fw = null;
        String path = logDir.equals("/tmp") ? (NzConstants.OS.startsWith("windows") ? "C:" : "/tmp") : logDir;
        fullpath.append(path);
        fullpath.append("/");
        fullpath.append(fileName);
        try {
            if (logType == 1) {
                fullpath.append(".nzlog");
                fw = new FileWriter(fullpath.toString(), true);
            } else {
                fullpath.append(".nzbad");
                fw = new FileWriter(fullpath.toString());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        while ((numBytes = this.connection.receiveIntR(4)) != 0) {
            this.connection.receiveBytes(databuffer, 0, numBytes);
            String data = new String(databuffer, 0, numBytes);
            try {
                fw.write(data);
            }
            catch (Exception ex) {}
        }
        try {
            fw.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String method = "run";
        this.connection.LOGGER.entry(this.getClass(), method);
        try {
            int bytesRead = 0;
            int totalBytes = 0;
            while (!this.connection.stopLoading) {
                bytesRead = this.stream.read(this.blockBuffer, totalBytes, this.blockSize - totalBytes);
                if (bytesRead == -1) {
                    if (totalBytes <= 0) break;
                    this.connection.sendInt(1, 4);
                    this.connection.sendInt(totalBytes, 4);
                    this.connection.sendBytes(this.blockBuffer, totalBytes);
                    break;
                }
                if (bytesRead == 0 || (totalBytes += bytesRead) < this.blockSize) continue;
                this.connection.sendInt(1, 4);
                this.connection.sendInt(totalBytes, 4);
                this.connection.sendBytes(this.blockBuffer, totalBytes);
                totalBytes = 0;
                this.reading = !this.connection.isDataAvailable(1L);
            }
            if (!this.connection.stopLoading) {
                this.connection.sendInt(3, 4);
                this.connection.flush();
                this.loadStatus = 3;
            } else {
                this.connection.sendInt(2, 4);
                this.connection.sendInt(3, 4);
                String errormsg = "ET load is aborted";
                this.connection.sendInt(errormsg.length() + 1, 4);
                this.connection.sendBytes(Encoding.UNICODE.encode(errormsg));
                this.connection.sendChar('\u0000');
                String errormsg1 = "NzXferExtTable.run";
                this.connection.sendInt(errormsg1.length() + 1, 4);
                this.connection.sendBytes(Encoding.UNICODE.encode(errormsg1));
                this.connection.sendChar('\u0000');
                this.connection.flush();
                this.loadStatus = 2;
            }
            this.reading = false;
            this.connection.loading = false;
            this.connection.stopLoading = false;
        }
        catch (Exception e) {
            this.reading = false;
            this.connection.loading = false;
            this.connection.stopLoading = false;
            this.loadStatus = 2;
        }
        finally {
            this.connection.LOGGER.exit(this.getClass(), method);
            this.reading = false;
            try {
                this.stream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void cleanUpLoad() throws SQLException {
        this.connection.sendInt(2, 4);
        this.connection.sendInt(1, 4);
        String errormsg = "unable to open dataobject";
        this.connection.sendInt(errormsg.length() + 1, 4);
        this.connection.sendBytes(Encoding.UNICODE.encode(errormsg));
        this.connection.sendChar('\u0000');
        String errormsg1 = "file reader";
        this.connection.sendInt(errormsg1.length() + 1, 4);
        this.connection.sendBytes(Encoding.UNICODE.encode(errormsg1));
        this.connection.sendChar('\u0000');
        this.connection.flush();
    }

    @Override
    public boolean isReading() {
        return this.reading;
    }
}

