/*
 * Decompiled with CFR 0.152.
 */
package org.netezza;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import org.netezza.core.NzConstants;
import org.netezza.datasource.NzDatasource;
import org.netezza.datasource.NzDatasourceException;
import org.netezza.datasource.NzDatasourceFactory;
import org.netezza.internal.NzDriverExpiration;
import org.netezza.internal.NzURL;
import org.netezza.sql.NzConnection;

public class Driver
implements java.sql.Driver {
    private static final Properties properties;
    private static final NzDatasourceFactory DATASOURCE_FACTORY;
    private static String installationDirPath;
    private static final String FILE = "file:";
    public static int MAJOR_VERSION;
    public static int MINOR_VERSION;
    public static String VERSION;
    public static String NAME;
    public static String DATABASE_PRODUCT_NAME;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        NzURL nzURL = new NzURL(url, properties);
        try {
            return nzURL.parse();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (NzDriverExpiration.isDriverExpired()) {
            throw new SQLException("Netezza Driver expired on null.\nDriver Version: " + Driver.getVersion() + "\nPlease contact Netezza support and provide this message.");
        }
        NzURL _url = new NzURL(url, info);
        if (!_url.parse()) {
            return null;
        }
        NzDatasource datasource = _url.getDatasource();
        NzConnection connection = (NzConnection)datasource.getConnection();
        connection.setDriver(this);
        return connection;
    }

    @Override
    public int getMajorVersion() {
        return MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return MINOR_VERSION;
    }

    public String getName() {
        return NAME;
    }

    public String getDatabaseProductName() {
        return DATABASE_PRODUCT_NAME;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getInstallationDirectoryPath() {
        if (installationDirPath != null) {
            return installationDirPath;
        }
        String name = Driver.class.getName();
        name = name.substring(name.lastIndexOf(46) + 1) + ".class";
        String path = Driver.class.getResource(name).getPath();
        int index = path.lastIndexOf(33);
        path = path.substring(0, index);
        path = NzConstants.OS.toLowerCase().indexOf("windows") != -1 ? path.substring(FILE.length() + 1) : path.substring(FILE.length());
        String file = new File(path).getAbsolutePath();
        installationDirPath = file.substring(0, file.lastIndexOf(NzConstants.FILE_SEPARATOR));
        installationDirPath = installationDirPath.replaceAll("%20", " ");
        return installationDirPath;
    }

    public static String getConfigerationFilePath() {
        try {
            return Driver.getInstallationDirectoryPath() + NzConstants.FILE_SEPARATOR + "nzjdbc.ini";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getDefaultLogDirectoryPath() {
        String os = System.getProperty("os.name").trim().toLowerCase();
        if (os.startsWith("windows")) {
            return "C:\\";
        }
        return "/tmp/";
    }

    public static void save() throws SQLException {
        DATASOURCE_FACTORY.store();
    }

    public static void setDatasourceProperty(NzDatasource source, String key, String value) throws SQLException {
        DATASOURCE_FACTORY.setDatasourceProperty(source, key, value);
    }

    public static NzDatasource removeDataSource(NzDatasource source) {
        return DATASOURCE_FACTORY.removeDataSource(source);
    }

    public static NzDatasource removeDatasource(String name) throws SQLException {
        return DATASOURCE_FACTORY.removeDatasource(name);
    }

    public static NzDatasource getDatasource(String name) {
        return DATASOURCE_FACTORY.getDataSource(name);
    }

    public static void addDatasource(NzDatasource source) throws NzDatasourceException {
        DATASOURCE_FACTORY.addDatasource(source);
    }

    public static String toString(NzDatasource source, Boolean forLogging) {
        return DATASOURCE_FACTORY.toString(source, forLogging);
    }

    public static Vector<NzDatasource> getDatasources() {
        return DATASOURCE_FACTORY.getDatasources();
    }

    public static boolean isPresent(String name) {
        return DATASOURCE_FACTORY.isPresent(name);
    }

    public static String[] getDatasourceNames() {
        return DATASOURCE_FACTORY.getDatasourceNames();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        SQLFeatureNotSupportedException etothrow = new SQLFeatureNotSupportedException("Feature 'getParentLogger' is not supported by Netezza JDBC driver");
        throw etothrow;
    }

    static {
        DATASOURCE_FACTORY = new NzDatasourceFactory();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("nzjdbc_version");
            VERSION = bundle.getString("full.version");
            MAJOR_VERSION = Integer.parseInt(bundle.getString("major.version"));
            MINOR_VERSION = Integer.parseInt(bundle.getString("minor.version"));
            NAME = bundle.getString("driver.name");
            DATABASE_PRODUCT_NAME = bundle.getString("database.product.name");
            DATASOURCE_FACTORY.load(Driver.getConfigerationFilePath());
        }
        catch (Exception e) {
            // empty catch block
        }
        properties = new Properties();
        try {
            DriverManager.registerDriver(new Driver());
            properties.put("user", "nz");
            properties.put("password", "nz");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

