/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.ui;

import com.dbeaver.cloud.azure.AzureCloudConfiguration;
import com.dbeaver.cloud.azure.ui.internal.AzureMessages;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.util.UUID;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class AzureConfigurationEditor
implements IObjectPropertyConfigurator<Object, AzureCloudConfiguration> {
    private Text clientIdText;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable listener) {
        TabFolder tabs = new TabFolder(parent, 0x800080);
        Composite composite = new Composite((Composite)tabs, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.clientIdText = UIUtils.createLabelText((Composite)composite, (String)AzureMessages.config_editor_auth_client_id_label, null);
        this.clientIdText.setToolTipText(AzureMessages.config_editor_auth_client_id_tip);
        this.clientIdText.addModifyListener(e -> listener.run());
        TabItem authentication = new TabItem(tabs, 0);
        authentication.setText(AzureMessages.config_editor_auth_title);
        authentication.setControl((Control)composite);
    }

    public void loadSettings(@NotNull AzureCloudConfiguration configuration) {
        AuthModelAzureCredentials credentials = configuration.getCredentials();
        this.clientIdText.setText(CommonUtils.notEmpty((String)credentials.getClientId()));
    }

    public void saveSettings(@NotNull AzureCloudConfiguration configuration) {
        AuthModelAzureCredentials credentials = configuration.getCredentials();
        credentials.setClientId(this.clientIdText.getText());
    }

    public void resetSettings(@NotNull AzureCloudConfiguration configuration) {
    }

    public boolean isComplete() {
        try {
            UUID.fromString(this.clientIdText.getText());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

