/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceOriginExternal;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.utils.CommonUtils;

public abstract class DataSourceOriginCloud<CLOUD extends CPCloud<ZONE, ?>, ZONE extends CPCloudZone>
implements DBPDataSourceOriginExternal {
    public static final String ORIGIN_TYPE = "cloud";
    public static final String PROPERTY_CLOUD_PROVIDER = "cloud-provider";
    public static final String PROPERTY_CLOUD_ID = "cloud-id";
    public static final String PROPERTY_CLOUD_ZONE_ID = "cloud-zone-id";
    private final CloudProviderDescriptor provider;
    private final Map<String, Object> configuration;
    private final DBPExternalConfiguration externalConfiguration;

    public DataSourceOriginCloud(CloudProviderDescriptor cloudProvider, Map<String, Object> configuration, DBPExternalConfiguration externalConfiguration) {
        this.provider = cloudProvider;
        this.configuration = configuration;
        this.externalConfiguration = externalConfiguration;
    }

    public CloudProviderDescriptor getCloudProvider() {
        return this.provider;
    }

    public CLOUD getCloud() {
        String cloudId = CommonUtils.toString((Object)this.configuration.get(PROPERTY_CLOUD_ID), null);
        CPCloud<?, ?> cloud = CPCloudUtils.getCloud(this.provider, cloudId, this.externalConfiguration);
        if (cloud == null) {
            throw new IllegalStateException("Origin cloud '" + cloudId + "' not found in '" + this.provider.getId() + "'");
        }
        return (CLOUD)cloud;
    }

    public ZONE getZone() {
        String zoneId;
        CLOUD cloud = this.getCloud();
        if (cloud != null && (zoneId = CommonUtils.toString((Object)this.configuration.get(PROPERTY_CLOUD_ZONE_ID), null)) != null) {
            return (ZONE)CPCloudUtils.findZone(cloud, zoneId);
        }
        return null;
    }

    public abstract String getResourceId();

    @NotNull
    public String getType() {
        return ORIGIN_TYPE;
    }

    @Nullable
    public String getSubType() {
        return this.provider.getId();
    }

    @NotNull
    public String getDisplayName() {
        return this.getCloud().getName();
    }

    @Nullable
    public DBPImage getIcon() {
        return this.provider.getIcon();
    }

    public boolean isDynamic() {
        return true;
    }

    @NotNull
    public Map<String, Object> getDataSourceConfiguration() {
        return this.configuration;
    }

    @Nullable
    public DBPExternalConfiguration getExternalConfiguration() {
        return this.externalConfiguration;
    }

    public String toString() {
        return String.valueOf(this.getType()) + "." + this.getSubType() + ":" + this.getResourceId();
    }
}

