/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudSessionProvider;
import com.dbeaver.cloud.registry.CloudConfigurationProviderDescriptor;
import com.dbeaver.cloud.registry.CloudCredentialsProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.app.DBPApplicationDesktop;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class CloudProviderRegistry {
    private static final Log log = Log.getLog(CloudProviderRegistry.class);
    private static final String CLOUD_PROVIDER_EXTENSION_ID = "com.dbeaver.cloud.provider";
    private static final String TAG_PROVIDER = "cloudProvider";
    private static final String TAG_CREDENTIALS_PROVIDER = "credentialsProvider";
    private static final String TAG_CONFIGURATION_PROVIDER = "configurationProvider";
    private static CloudProviderRegistry instance;
    private final List<CloudProviderDescriptor> cloudProviders = new ArrayList<CloudProviderDescriptor>();
    private final List<CloudCredentialsProviderDescriptor> sessionProviders = new ArrayList<CloudCredentialsProviderDescriptor>();
    private final Map<String, CloudConfigurationProviderDescriptor> configurationProviders = new HashMap<String, CloudConfigurationProviderDescriptor>();

    public static synchronized CloudProviderRegistry getInstance() {
        if (instance == null) {
            instance = new CloudProviderRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private CloudProviderRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        boolean isDesktop = DBWorkbench.getPlatform().getApplication() instanceof DBPApplicationDesktop;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(CLOUD_PROVIDER_EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            CloudConfigurationProviderDescriptor configurationProvider;
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_PROVIDER.equals(ext.getName())) {
                CloudProviderDescriptor descriptor = new CloudProviderDescriptor(ext);
                this.cloudProviders.add(descriptor);
            } else if (TAG_CREDENTIALS_PROVIDER.equals(ext.getName())) {
                CloudCredentialsProviderDescriptor credentialsProvider = new CloudCredentialsProviderDescriptor(ext);
                if (isDesktop == credentialsProvider.isDesktop()) {
                    this.sessionProviders.add(credentialsProvider);
                }
            } else if (TAG_CONFIGURATION_PROVIDER.equals(ext.getName()) && isDesktop == (configurationProvider = new CloudConfigurationProviderDescriptor(ext)).isDesktop()) {
                this.configurationProviders.put(configurationProvider.getId(), configurationProvider);
            }
            ++n2;
        }
        this.cloudProviders.sort(Comparator.comparing(CloudProviderDescriptor::getLabel));
    }

    public CloudProviderDescriptor getCloudProvider(String id) {
        for (CloudProviderDescriptor descriptor : this.cloudProviders) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public List<CloudConfigurationProviderDescriptor> getConfigurationProviders() {
        return new ArrayList<CloudConfigurationProviderDescriptor>(this.configurationProviders.values());
    }

    public CPCloudConfigurationProvider<?> getConfigurationProvider(String providerId) {
        CloudConfigurationProviderDescriptor descriptor = this.configurationProviders.get(providerId);
        try {
            return descriptor == null ? null : descriptor.getInstance();
        }
        catch (DBException e) {
            log.debug((Object)e);
            return null;
        }
    }

    public List<CloudProviderDescriptor> getCloudProviders() {
        return new ArrayList<CloudProviderDescriptor>(this.cloudProviders);
    }

    public CPCloudSessionProvider<?> getSessionProvider(CPCloud<?, ?> cloud) {
        for (CloudCredentialsProviderDescriptor ccp : this.sessionProviders) {
            if (!ccp.appliesTo((DBPObject)cloud)) continue;
            try {
                return ccp.getInstance();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        return null;
    }
}

