/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class BaseCloudConfigurationProvider<CONFIG extends CPCloudConfiguration>
implements CPCloudConfigurationProvider<CONFIG> {
    protected static final Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private static final Log log = Log.getLog(BaseCloudConfigurationProvider.class);
    private static final String CLOUD_CONFIG_FOLDER = ".cloud-data";

    protected abstract String getCloudTypeId();

    protected abstract Class<CONFIG> getCloudConfigurationClass();

    @NotNull
    protected Path getCloudConfigFolder(boolean create) {
        Path cloudsFolder = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(CLOUD_CONFIG_FOLDER);
        if (create && !Files.exists(cloudsFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(cloudsFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Cannot create directory '" + cloudsFolder.toAbsolutePath() + "'"), (Throwable)e);
            }
        }
        return cloudsFolder;
    }

    @NotNull
    protected Path getCloudConfigFile(boolean create) {
        return this.getCloudConfigFolder(create).resolve(String.valueOf(this.getCloudTypeId()) + "-clouds.json");
    }

    @NotNull
    protected String getCloudConfigurationFileName() {
        return "clouds/" + this.getCloudTypeId() + "-clouds.json";
    }

    @Override
    @NotNull
    public List<CONFIG> loadCloudConfigurations() {
        try {
            Path cloudConfigFile;
            String configContent = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(this.getCloudConfigurationFileName());
            if (CommonUtils.isEmpty((String)configContent) && Files.exists(cloudConfigFile = this.getCloudConfigFile(false), new LinkOption[0])) {
                configContent = Files.readString(cloudConfigFile, StandardCharsets.UTF_8);
            }
            if (!CommonUtils.isEmpty((String)configContent)) {
                CPCloudConfiguration[] configs;
                Class<?> arrClass = Array.newInstance(this.getCloudConfigurationClass(), 0).getClass();
                CPCloudConfiguration[] cPCloudConfigurationArray = configs = (CPCloudConfiguration[])gson.fromJson(configContent, arrClass);
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    CPCloudConfiguration cfg = cPCloudConfigurationArray[n2];
                    this.loadSecureProperties(cfg);
                    ++n2;
                }
                return List.of(configs);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading cloud configuration", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public CONFIG loadExternalCloudConfiguration(DBPExternalConfiguration externalConfiguration) {
        Gson gson = CPCloudUtils.createSecureGson(false);
        String jsonString = gson.toJson((Object)externalConfiguration.getProperties());
        return (CONFIG)((CPCloudConfiguration)gson.fromJson(jsonString, this.getCloudConfigurationClass()));
    }

    protected void loadSecureProperties(CONFIG configuration) {
    }

    protected boolean saveSecureProperties(CONFIG cfg) {
        return false;
    }

    @Override
    public void saveConfigurations(@NotNull Collection<CONFIG> configurations) {
        boolean securePropsSaved = false;
        for (CPCloudConfiguration cfg : configurations) {
            if (!this.saveSecureProperties(cfg)) continue;
            securePropsSaved = true;
        }
        Gson saveGson = securePropsSaved ? CPCloudUtils.createSecureGson(securePropsSaved) : gson;
        StringWriter buf = new StringWriter();
        try {
            JsonWriter jsonWriter = saveGson.newJsonWriter((Writer)buf);
            saveGson.toJson(configurations, configurations.getClass(), jsonWriter);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        try {
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(this.getCloudConfigurationFileName(), buf.toString());
        }
        catch (DBException e) {
            log.error((Object)"Error saving cloud configuration", (Throwable)e);
        }
        CPCloudConfigurationRegistry.getInstance().fireCloudConfigurationChange();
    }

    @Override
    @NotNull
    public CONFIG createConfiguration() {
        try {
            return (CONFIG)((CPCloudConfiguration)this.getCloudConfigurationClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create cloud configuration", e);
        }
    }

    @Override
    public Map<String, Object> serializeCloudConfiguration(CONFIG configuration) {
        Gson gson = CPCloudUtils.createSecureGson(false);
        String jsonString = gson.toJson(configuration, configuration.getClass());
        return JSONUtils.parseMap((Gson)gson, (Reader)new StringReader(jsonString));
    }
}

