/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model.navigator;

import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.model.navigator.DBNCloudServiceNode;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPObjectWithDetails;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNCloudDataSourceNode
extends DBNDataSource
implements DBPObjectWithDetails<DBNCloudDataSourceNode> {
    private static final Log log = Log.getLog(DBNCloudDataSourceNode.class);
    private final CPDatabaseInstance instance;

    public DBNCloudDataSourceNode(DBNNode parentNode, CPDatabaseInstance instance, DBPDataSourceContainer dataSourceContainer) {
        super(parentNode, dataSourceContainer);
        this.instance = instance;
    }

    public CPDatabaseNode getInstance() {
        return this.instance;
    }

    public String getNodeType() {
        return "databaseInstance";
    }

    public String getNodeName() {
        return this.instance.getNodeDisplayName();
    }

    public String getNodeDescription() {
        return this.instance.getDescription();
    }

    public DBPImage getNodeIcon() {
        DBPImage icon = this.instance.getNodeIcon();
        return icon != null ? icon : this.getParentNode().getNodeIcon();
    }

    public boolean moveToFolder(DBPProject project, DBPDataSourceFolder folder) {
        try {
            CPCloudUtils.createDataSourcesFromCloudNodes(project, folder, Collections.singletonList(this));
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return true;
    }

    protected void dispose(boolean reflect) {
        ((DBNCloudServiceNode)this.getParentNode()).getCloudNode().getDataSourceRegistry().removeDataSource(this.getDataSourceContainer());
        super.dispose(reflect);
    }

    @Nullable
    public DBPObject getObjectDetails(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext sessionContext, @NotNull DBNCloudDataSourceNode dataSource) throws DBException {
        if (this.instance instanceof CPDatabaseInstance) {
            return new InstanceDetails(this.instance);
        }
        return null;
    }

    public static class InstanceDetails
    implements DBPObject {
        private final CPDatabaseInstance instance;

        public InstanceDetails(CPDatabaseInstance instance) {
            this.instance = instance;
        }

        @Property(order=1)
        @NotNull
        public String getZone() {
            return this.instance.getZone().getZoneId();
        }

        @Property(order=2)
        @Nullable
        public String getEndpoint() {
            return this.instance.getInstanceEndpoint();
        }
    }
}

