/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.model.navigator.DBNCloudDataSourceNode;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class CPCloudUtils {
    private static final Log log = Log.getLog(CPCloudUtils.class);

    @Nullable
    public static CPCloud<?, ?> getCloud(@NotNull String cloudId) {
        return CPCloudUtils.getCloud(null, cloudId, null);
    }

    @Nullable
    public static CPCloud<?, ?> getCloud(@Nullable CloudProviderDescriptor provider, @NotNull String cloudId, @Nullable DBPExternalConfiguration externalConfiguration) {
        CPCloud<?, ?> cloud = null;
        if (provider == null) {
            List<CloudProviderDescriptor> providers = CloudProviderRegistry.getInstance().getCloudProviders();
            for (CloudProviderDescriptor cpDescriptor : providers) {
                cloud = CPCloudUtils.findCloudInProvider(cpDescriptor, cloudId);
                if (cloud == null) {
                    continue;
                }
                break;
            }
        } else {
            cloud = CPCloudUtils.findCloudInProvider(provider, cloudId);
        }
        if (cloud == null && provider != null && externalConfiguration != null) {
            if (!CommonUtils.equalObjects((Object)externalConfiguration.getId(), (Object)cloudId)) {
                log.debug((Object)("ID in external configuration (" + externalConfiguration.getId() + ") doesn't match cloud ID (" + cloudId + ")"));
            } else {
                Object cloudConfiguration;
                CPCloudConfigurationProvider<?> configurationProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(provider.getId());
                if (configurationProvider != null && (cloudConfiguration = configurationProvider.loadExternalCloudConfiguration(externalConfiguration)) != null) {
                    CPCloudConfigurationRegistry.getInstance().fireCloudConfigurationChange();
                    cloud = CPCloudUtils.findCloudInProvider(provider, cloudId);
                }
            }
        }
        return cloud;
    }

    private static CPCloud<?, ?> findCloudInProvider(CloudProviderDescriptor provider, String cloudId) {
        for (CPCloud<?, ?> cloud : provider.getInstance().getAvailableClouds()) {
            if (!cloud.getCloudId().equals(cloudId)) continue;
            return cloud;
        }
        return null;
    }

    @Nullable
    public static CPCloud<?, ?> getCloud(CloudProviderDescriptor provider, String cloudId) {
        if (provider != null) {
            for (CPCloud<?, ?> cloud : provider.getInstance().getAvailableClouds()) {
                if (!cloud.getCloudId().equals(cloudId)) continue;
                return cloud;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends CPCloudConfiguration> T getCloudConfiguration(String cloudId, Class<T> configurationType) {
        CPCloud<?, ?> cloud = CPCloudUtils.getCloud(null, cloudId, null);
        if (cloud != null) {
            return (T)((CPCloudConfiguration)configurationType.cast(cloud.getCloudConfiguration()));
        }
        return null;
    }

    @Nullable
    public static CPCloudZone findZone(CPCloud<?, ?> cloud, String zoneId) {
        CPCloudZone[] cPCloudZoneArray = cloud.getAllZones();
        int n = cPCloudZoneArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPCloudZone zone = cPCloudZoneArray[n2];
            if (zone.getZoneId().equals(zoneId)) {
                return zone;
            }
            ++n2;
        }
        return null;
    }

    @NotNull
    public static List<DBPDataSourceContainer> createDataSourcesFromCloudNodes(@NotNull DBPProject project, @Nullable DBPDataSourceFolder folder, @NotNull List<DBNCloudDataSourceNode> nodes) throws DBException {
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project);
        if (projectNode == null) {
            throw new DBException("Project node '" + project.getName() + "' not found");
        }
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
        for (DBNCloudDataSourceNode dsNode : nodes) {
            DBPDataSourceContainer dataSourceContainer = dsNode.getDataSourceContainer();
            DBPDataSourceContainer newDataSource = CPCloudUtils.createDataSourceFromCloudTemplate(dataSourceRegistry, folder, dataSourceContainer);
            result.add(newDataSource);
        }
        return result;
    }

    @NotNull
    private static DBPDataSourceContainer createDataSourceFromCloudTemplate(@NotNull DBPDataSourceRegistry dataSourceRegistry, @Nullable DBPDataSourceFolder folder, @NotNull DBPDataSourceContainer dataSourceContainer) throws DBException {
        DBPDataSourceContainer ds;
        DBPDataSourceContainer newDataSource = dataSourceRegistry.createDataSource(dataSourceContainer);
        if (folder != null) {
            newDataSource.setFolder(folder);
        }
        String dsName = newDataSource.getName();
        int tryCount = 1;
        while ((ds = dataSourceRegistry.findDataSourceByName(dsName)) != null && !ds.isHidden()) {
            dsName = String.valueOf(newDataSource.getName()) + " (" + tryCount + ")";
            ++tryCount;
        }
        newDataSource.setName(dsName);
        dataSourceRegistry.addDataSource(newDataSource);
        return newDataSource;
    }

    public static DBPDataSourceContainer findOrCreateDataSourceByInstance(DBRProgressMonitor monitor, DBPProject project, CPDatabaseInstance databaseInstance) throws DBException {
        String resourceId = databaseInstance.getCloudResourceId();
        DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
        for (DBPDataSourceContainer ds : dataSourceRegistry.getDataSources()) {
            DBPDataSourceOrigin dsOrigin;
            if (ds.isHidden() || !((dsOrigin = ds.getOrigin()) instanceof DataSourceOriginCloud) || !resourceId.equals(((DataSourceOriginCloud)dsOrigin).getResourceId())) continue;
            return ds;
        }
        DBPDataSourceContainer templateDataSource = dataSourceRegistry.getDataSource(resourceId);
        if (templateDataSource == null) {
            templateDataSource = databaseInstance.createDataSourceContainer(monitor, dataSourceRegistry);
        }
        DBPDataSourceContainer resultDS = CPCloudUtils.createDataSourceFromCloudTemplate(dataSourceRegistry, null, templateDataSource);
        return resultDS;
    }

    @NotNull
    public static Gson createSecureGson(boolean saveSecureProperties) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().setLenient();
        if (!saveSecureProperties) {
            builder.addSerializationExclusionStrategy((ExclusionStrategy)new SecurePropertiesExclusionStrategy());
        }
        return builder.create();
    }

    private static class SecurePropertiesExclusionStrategy
    implements ExclusionStrategy {
        private SecurePropertiesExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(SecureProperty.class) != null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

