/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationListener;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;

public abstract class BaseCloudProvider<CLOUD extends CPCloud<?, ?>>
implements CPCloudProvider,
CPCloudConfigurationListener {
    private List<CLOUD> allClouds;

    public BaseCloudProvider() {
        CPCloudConfigurationRegistry.getInstance().addConfigurationChangeListener(this, true);
    }

    @NotNull
    public synchronized List<CLOUD> getAvailableClouds() {
        if (this.allClouds == null) {
            CPCloudConfigurationProvider<?> configurationProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(this.getCloudProviderId());
            List<Object> configurations = new ArrayList();
            if (configurationProvider != null) {
                configurations = configurationProvider.loadCloudConfigurations();
            }
            this.allClouds = new ArrayList<CLOUD>();
            for (CPCloudConfiguration cPCloudConfiguration : configurations) {
                CLOUD cloud = this.createCloudFromConfiguration(cPCloudConfiguration);
                if (cloud == null) continue;
                this.allClouds.add(cloud);
            }
        }
        return this.allClouds;
    }

    @Override
    public void handleCloudConfigurationChange() {
        this.reloadClouds();
    }

    public void reloadClouds() {
        this.allClouds = null;
    }

    public abstract CLOUD createCloudFromConfiguration(CPCloudConfiguration var1);
}

