/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.snapshot;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.snapshot.jvm.SchemaSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.util.JdbcUtils;

public class DatabricksSchemaSnapshotGenerator
extends SchemaSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof DatabricksDatabase) {
            int priority = super.getPriority(objectType, database);
            return priority += 5;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getDatabaseSchemaNames(Database database) throws SQLException, DatabaseException {
        HashSet<String> returnList = new HashSet<String>();
        try (ResultSet schemas = null;){
            schemas = ((JdbcConnection)database.getConnection()).getMetaData().getSchemas();
            while (schemas.next()) {
                returnList.add(JdbcUtils.getValueForColumn((ResultSet)schemas, (String)"TABLE_SCHEM", (Database)database));
            }
        }
        return returnList.toArray(new String[returnList.size()]);
    }
}

