/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.database;

import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawCallStatement;
import liquibase.structure.DatabaseObject;

public class DatabricksDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "SparkSQL";

    public DatabricksDatabase() {
        super.setCurrentDateTimeFunction("NOW()");
    }

    public String getShortName() {
        return "databricks";
    }

    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Integer getDefaultPort() {
        return 443;
    }

    public int getPriority() {
        return 5;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:spark:")) {
            return "com.simba.spark.jdbc.Driver";
        }
        return null;
    }

    public boolean supportsCatalogs() {
        return true;
    }

    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return false;
    }

    protected SqlStatement getConnectionSchemaNameCallStatement() {
        return new RawCallStatement("SELECT current_database()");
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsSchemas() {
        return true;
    }
}

