/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.bigquery.ui.config;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.bigquery.ui.internal.BigQueryMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ConfigurationFileSelector;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.utils.CommonUtils;

public class BigQueryAuthConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Combo authTypeCombo;
    private TextWithOpenFile authCertFile;

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        UIUtils.createControlLabel((Composite)authPanel, (String)BigQueryMessages.label_oauth_type);
        this.authTypeCombo = new Combo(authPanel, 2060);
        this.authTypeCombo.add(BigQueryMessages.label_service_based);
        this.authTypeCombo.add(BigQueryMessages.label_user_based);
        this.authTypeCombo.select(0);
        UIUtils.createControlLabel((Composite)authPanel, (String)BigQueryMessages.label_key_path);
        this.authCertFile = new ConfigurationFileSelector(authPanel, BigQueryMessages.label_private_key_path, new String[]{"*", "*.p12", "*.json"});
        this.authCertFile.setLayoutData((Object)new GridData(800));
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        String keyPath;
        super.loadSettings(dataSource);
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.authTypeCombo != null) {
            this.authTypeCombo.select(CommonUtils.toInt((Object)connectionInfo.getProperty("OAuthType")));
        }
        if ((keyPath = connectionInfo.getProperty("OAuthPvtKeyPath")) != null && this.authCertFile != null) {
            this.authCertFile.setText(keyPath);
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.authTypeCombo != null) {
            connectionInfo.setProperty("OAuthType", String.valueOf(this.authTypeCombo.getSelectionIndex()));
        }
        if (this.authCertFile != null) {
            connectionInfo.setProperty("OAuthPvtKeyPath", this.authCertFile.getText().trim());
        }
    }
}

