/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.NameHandling;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.security.AuthenticationManagerInterface;
import java.sql.SQLException;

public class NativeAuthenticationManager
implements AuthenticationManagerInterface {
    protected static final int RTEAuth_Manager_State_Initial = 0;
    protected static final int RTEAuth_Manager_State_VerifierRequest = 1;
    protected static final int RTEAuth_Manager_State_CallbackRequest = 2;
    protected static final int RTEAuth_Manager_State_Continue = 3;
    protected static final int RTEAuth_Manager_State_Final = 4;
    protected static final int RTEAuth_Manager_State_Complete = 5;
    protected static final int RTEAuth_Manager_State_Error = 6;
    protected int evalState;
    protected byte[] outputData = null;

    public NativeAuthenticationManager() {
    }

    public NativeAuthenticationManager(ConnectionSapDB conn, String userRaw, String password, boolean isUserPasswdAscii) throws SQLException {
        try {
            this.evaluateConnect(conn, userRaw, password, isUserPasswdAscii, false);
        }
        catch (DBMException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", new Integer(this.evalState));
        }
        catch (RTEException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", new Integer(this.evalState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateConnect(Object conn, String userRaw, String password, boolean isUserPasswdAscii, boolean useDBMProtocol) throws SQLException, RTEException, DBMException {
        String userStripped = NameHandling.stripUsername(userRaw);
        long authManager = this.init(userStripped, password, isUserPasswdAscii, useDBMProtocol);
        if (authManager == 0L) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", new Integer(this.evalState));
        }
        try {
            this.evalState = 0;
            byte[] inputData = null;
            while (true) {
                this.outputData = this.evaluate(authManager, password, inputData);
                if (this.outputData == null) {
                    throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", new Integer(this.evalState));
                }
                if (this.evalState == 4) {
                    break;
                }
                if (this.evalState == 1) {
                    throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthentication_verifier_request");
                }
                if (this.evalState != 3) {
                    // empty if block
                }
                String userEscaped = NameHandling.stripUsernameEscaped(userRaw);
                inputData = this.sendPacket(conn, userEscaped, isUserPasswdAscii);
            }
        }
        finally {
            this.release(authManager);
        }
    }

    protected byte[] sendPacket(Object conn, String user, boolean isUserPasswdAscii) throws SQLException, RTEException, DBMException {
        RequestPacket reqPckg = ((ConnectionSapDB)conn).getRequestPacket(!isUserPasswdAscii);
        DataPartVariable dpOutput = reqPckg.initAuthenticationMethodRequest(user);
        dpOutput.addArg(0, 0);
        dpOutput.putRawData(this.outputData, dpOutput.getCurrentOffset());
        dpOutput.close();
        ReplyPacket replPckg = ((ConnectionSapDB)conn).execute(reqPckg, this, 2);
        if (replPckg.findDataPart() == -1) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", new Integer(this.evalState));
        }
        return replPckg.getRawPart();
    }

    public int getMaxPasswordLength() {
        return -1;
    }

    public void addClientProofPart(RequestPacket requestPacket, String user, String pwd, boolean isUnicode) throws SQLException {
        DataPartVariable dpOutput = (DataPartVariable)requestPacket.newDataPart(true);
        dpOutput.addArg(0, 0);
        dpOutput.addArg(0, 0);
        dpOutput.addArg(0, 0);
        dpOutput.putRawData(this.outputData, dpOutput.getCurrentOffset());
        dpOutput.close();
    }

    public String getFinalDBMConnectCmd(String pwd, boolean isUnicode) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", new Integer(this.evalState));
    }

    native long init(String var1, String var2, boolean var3, boolean var4);

    native byte[] evaluate(long var1, String var3, byte[] var4);

    native void release(long var1);
}

