/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.Tracer;

class CommunicationException
extends RTEException {
    private int RTEReturncode;

    public CommunicationException(int rc, Tracer tracer) {
        super(CommunicationException.mapRC(rc), tracer, rc);
        this.RTEReturncode = rc;
    }

    private static String mapRC(int rc) {
        String result = "Error";
        switch (rc) {
            case 1: {
                result = "Communication Error";
                break;
            }
            case 2: {
                result = "Tasklimit";
                break;
            }
            case 3: {
                result = "Timeout";
                break;
            }
            case 4: {
                result = "Crash";
                break;
            }
            case 5: {
                result = "Start required";
                break;
            }
            case 6: {
                result = "Shutdown";
                break;
            }
            case 7: {
                result = "Send line down";
                break;
            }
            case 8: {
                result = "Receive line down";
                break;
            }
            case 9: {
                result = "Packet limit";
                break;
            }
            case 10: {
                result = "Released";
                break;
            }
            default: {
                result = "Communication Error, code " + String.valueOf(rc);
            }
        }
        return result;
    }

    public int getRTEReturncode() {
        return this.RTEReturncode;
    }
}

