/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.powertoys;

import com.sap.dbtech.util.StructuredMem;

public class LoaderException
extends Exception {
    private int errorCode;

    LoaderException(int eCode, String msg) {
        super(msg);
        this.errorCode = eCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        return "<LoaderException " + this.errorCode + " " + this.getMessage() + ">";
    }

    public static LoaderException create(StructuredMem packet) {
        int errorCode = 0;
        String message = null;
        if (packet.size() < 4) {
            return new LoaderException(-807, "Invalid size of loader reply message (" + packet.size() + " bytes)");
        }
        String rawString = packet.getString(4, packet.size() - 4).trim();
        int idx = rawString.indexOf("\n");
        if (idx != -1) {
            try {
                errorCode = Integer.parseInt(rawString.substring(0, idx));
            }
            catch (NumberFormatException numberFormatEx) {
                // empty catch block
            }
            message = rawString.substring(idx + 1).trim();
        }
        if (message == null) {
            message = rawString;
        }
        return new LoaderException(errorCode, message);
    }
}

