/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.WrapperDummy;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class DataSourceSapDBBase
extends WrapperDummy {
    public static final int DEFAULT_LOGINTIMEOUT = 30;
    public static final int DEFAULT_XATIMEOUT = 30;
    protected Properties connectProperties = new Properties();
    protected PrintWriter logWriter;

    public DataSourceSapDBBase() {
        this.connectProperties.setProperty("serverName", "localhost");
        this.connectProperties.setProperty("port", "7210");
    }

    public String getUser() {
        return this.connectProperties.getProperty("user");
    }

    public void setLoginTimeout(int timeout) {
        this.connectProperties.setProperty("logintimeout", Integer.toString(timeout));
    }

    public int getLoginTimeout() {
        String s = this.connectProperties.getProperty("logintimeout");
        if (s == null) {
            return 30;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatEx) {
            return 30;
        }
    }

    public void setTimeout(int timeout) {
        this.connectProperties.setProperty("timeout", Integer.toString(timeout));
    }

    public int getTimeout() {
        String s = this.connectProperties.getProperty("timeout");
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatEx) {
            return 0;
        }
    }

    public String getPassword() {
        return this.connectProperties.getProperty("password");
    }

    public String getDescription() {
        return this.connectProperties.getProperty("description");
    }

    public String getDatabaseName() {
        return this.connectProperties.getProperty("databaseName");
    }

    public String getServerName() {
        return this.connectProperties.getProperty("serverName");
    }

    public String getSqlMode() {
        return this.connectProperties.getProperty("sqlmode", "INTERNAL");
    }

    public void setUser(String user) {
        this.connectProperties.setProperty("user", user);
    }

    public void setPassword(String password) {
        this.connectProperties.setProperty("password", password);
    }

    public void setDatabaseName(String databaseName) {
        this.connectProperties.setProperty("databaseName", databaseName.toUpperCase());
    }

    public void setServerName(String serverName) {
        this.connectProperties.setProperty("serverName", serverName);
    }

    public void setPort(int port) {
        this.connectProperties.setProperty("port", Integer.toString(port));
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.connectProperties.getProperty("port", "7210"));
        }
        catch (NumberFormatException nfex) {
            return 7210;
        }
    }

    public void setUrl(String url) {
        this.setServerName(this.serverNameFromUrl(url));
        this.setDatabaseName(this.databaseNameFromUrl(url));
        this.setPort(this.portFromUrl(url));
    }

    public String getURL() {
        return "jdbc:sapdb://" + this.getServerName() + ":" + this.getPort() + "/" + this.getDatabaseName();
    }

    private int portFromUrl(String url) {
        int closingSlashPos;
        String host;
        int urlLength = url.length();
        int port = 7210;
        int slashPos = "jdbc:sapdb:".length();
        if (urlLength >= slashPos + 3 && url.substring(slashPos, slashPos + 2).equals("//") && (host = url.substring(slashPos + 2, closingSlashPos = url.indexOf(47, slashPos + 2))).indexOf(":") != -1) {
            try {
                port = Integer.parseInt(host.substring(host.indexOf(":") + 1));
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        return port;
    }

    private String serverNameFromUrl(String url) {
        String host;
        int slashPos;
        int urlLength = url.length();
        if (urlLength >= (slashPos = "jdbc:sapdb:".length()) + 3 && url.substring(slashPos, slashPos + 2).equals("//")) {
            int closingSlashPos = url.indexOf(47, slashPos + 2);
            host = url.substring(slashPos + 2, closingSlashPos);
            if (host.length() == 0) {
                host = "localhost";
            }
            if (host.indexOf(":") != -1) {
                host = host.substring(0, host.indexOf(":"));
            }
        } else {
            host = "localhost";
        }
        return host;
    }

    private String databaseNameFromUrl(String url) {
        String dbname;
        int slashPos;
        int urlLength = url.length();
        if (urlLength >= (slashPos = "jdbc:sapdb:".length()) + 3 && url.substring(slashPos, slashPos + 2).equals("//")) {
            int closingSlashPos = url.indexOf(47, slashPos + 2);
            dbname = url.substring(closingSlashPos + 1, urlLength);
        } else {
            dbname = url.substring(slashPos, urlLength);
        }
        return dbname.toUpperCase();
    }

    public void setSqlMode(String sqlMode) {
        this.connectProperties.setProperty("sqlmode", sqlMode);
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public void setTransport(String transport) {
        this.connectProperties.setProperty("transport", transport);
    }

    public String getTransport() {
        return this.connectProperties.getProperty("transport", "socket");
    }

    public String getCache() {
        return this.connectProperties.getProperty("cache");
    }

    public void setCache(String cache) {
        this.connectProperties.setProperty("cache", cache);
    }

    public void setCacheSize(String cacheSize) {
        this.connectProperties.setProperty("cachesize", cacheSize);
    }

    public String getCacheSize() {
        return this.connectProperties.getProperty("cachesize");
    }

    public void setUnicode(String unicode) {
        this.connectProperties.setProperty("unicode", unicode);
    }

    public String getUnicode() {
        return this.connectProperties.getProperty("unicode", "false");
    }

    public void setSpaceOption(String option) {
        this.connectProperties.setProperty("spaceoption", option);
    }

    public String getSpaceOption() {
        return this.connectProperties.getProperty("spaceoption", "false");
    }

    public void setReconnect(String reconnect) {
        this.connectProperties.setProperty("reconnect", reconnect);
    }

    public String getReconnect() {
        return this.connectProperties.getProperty("reconnect");
    }

    public void setTrace(String trace) {
        this.connectProperties.setProperty("trace", trace);
    }

    public String getTrace() {
        return this.connectProperties.getProperty("trace");
    }

    public void setTraceSize(String tracesize) {
        this.connectProperties.setProperty("tracesize", tracesize);
    }

    public String getTraceSize() {
        return this.connectProperties.getProperty("tracesize");
    }

    public void setXATrace(String xatrace) {
        this.connectProperties.setProperty("xatrace", xatrace);
    }

    public String getXATrace() {
        return this.connectProperties.getProperty("xatrace");
    }

    public void setXATimeout(int xatimeout) {
        this.connectProperties.setProperty("xatimeout", Integer.toString(xatimeout));
    }

    public int getXATimeout() {
        String s = this.connectProperties.getProperty("xatimeout");
        if (s == null) {
            return 30;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatEx) {
            return 30;
        }
    }

    public void setProperties(Properties p) {
        this.connectProperties = (Properties)p.clone();
        if (this.connectProperties.getProperty("url") != null && this.connectProperties.getProperty("databaseName") == null) {
            this.setUrl(this.connectProperties.getProperty("url"));
        }
    }

    public Connection openPhysicalConnection() throws SQLException {
        Properties p = (Properties)this.connectProperties.clone();
        String serverName = p.getProperty("serverName", "localhost");
        String databaseName = p.getProperty("databaseName");
        if (databaseName == null) {
            throw SQLExceptionSapDB.generateSQLException("error.database.notset");
        }
        String url = "jdbc:sapdb://" + serverName + ":" + this.getPort() + "/" + databaseName;
        return DriverSapDB.singleton().connect(url, p);
    }

    public Connection openPhysicalConnection(String username, String password) throws SQLException {
        Properties p = (Properties)this.connectProperties.clone();
        p.setProperty("user", username);
        p.setProperty("password", password);
        String serverName = p.getProperty("serverName", "localhost");
        String databaseName = p.getProperty("databaseName");
        if (databaseName == null) {
            throw SQLExceptionSapDB.generateSQLException("error.database.notset");
        }
        String url = "jdbc:sapdb://" + serverName + ":" + this.getPort() + "/" + databaseName;
        return DriverSapDB.singleton().connect(url, p);
    }

    public Connection openPhysicalConnection(Properties p) throws SQLException {
        String serverName = p.getProperty("serverName", "localhost");
        String databaseName = p.getProperty("databaseName");
        if (databaseName == null) {
            throw SQLExceptionSapDB.generateSQLException("error.database.notset");
        }
        String url = "jdbc:sapdb://" + serverName + ":" + p.getProperty("port", "7210") + "/" + databaseName;
        return DriverSapDB.singleton().connect(url, p);
    }

    protected Reference createReference(String classname) {
        Reference result = new Reference(classname, "com.sap.dbtech.jdbcext.DataSourceSapDBFactory", null);
        if (this.getUser() != null) {
            result.add(new StringRefAddr("user", this.getUser()));
        }
        result.add(new StringRefAddr("logintimeout", Integer.toString(this.getLoginTimeout())));
        if (this.connectProperties.getProperty("timeout") != null) {
            result.add(new StringRefAddr("timeout", Integer.toString(this.getTimeout())));
        }
        if (this.getPassword() != null) {
            result.add(new StringRefAddr("password", this.getPassword()));
        }
        if (this.getDescription() != null) {
            result.add(new StringRefAddr("description", this.getDescription()));
        }
        if (this.getDatabaseName() != null) {
            result.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        }
        if (this.getServerName() != null) {
            result.add(new StringRefAddr("serverName", this.getServerName()));
        }
        if (this.getSqlMode() != null) {
            result.add(new StringRefAddr("sqlmode", this.getSqlMode()));
        }
        result.add(new StringRefAddr("port", Integer.toString(this.getPort())));
        if (this.getTransport() != null) {
            result.add(new StringRefAddr("transport", this.getTransport()));
        }
        if (this.getCache() != null) {
            result.add(new StringRefAddr("cache", this.getCache()));
        }
        if (this.getCacheSize() != null) {
            result.add(new StringRefAddr("cachesize", this.getCacheSize()));
        }
        if (this.getUnicode() != null) {
            result.add(new StringRefAddr("unicode", this.getUnicode()));
        }
        if (this.getReconnect() != null) {
            result.add(new StringRefAddr("reconnect", this.getReconnect()));
        }
        if (this.getTrace() != null) {
            result.add(new StringRefAddr("trace", this.getTrace()));
        }
        if (this.getTraceSize() != null) {
            result.add(new StringRefAddr("tracesize", this.getTraceSize()));
        }
        if (this.getXATrace() != null) {
            result.add(new StringRefAddr("xatrace", this.getXATrace()));
        }
        result.add(new StringRefAddr("xatimeout", Integer.toString(this.getXATimeout())));
        return result;
    }
}

