/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.TimeTranslator;
import java.sql.SQLException;

public class UnicodeInternalTimeTranslator
extends TimeTranslator {
    public UnicodeInternalTimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected int parseHours(byte[] raw) throws SQLException {
        int hours = (raw[1] - 48) * 1000;
        hours += (raw[3] - 48) * 100;
        hours += (raw[5] - 48) * 10;
        hours += raw[7] - 48;
        return hours %= 24;
    }

    protected int parseMinutes(byte[] raw) {
        return (raw[9] - 48) * 10 + (raw[11] - 48);
    }

    protected int parseSeconds(byte[] raw) {
        return (raw[13] - 48) * 10 + (raw[15] - 48);
    }

    protected byte[] formatTime(int hours, int minutes, int seconds) {
        byte[] formattedTime = new byte[16];
        formattedTime[1] = 48;
        formattedTime[3] = 48;
        formattedTime[5] = HighTime_C[hours];
        formattedTime[7] = LowTime_C[hours];
        formattedTime[9] = (byte)(48 + minutes / 10);
        formattedTime[11] = (byte)(48 + minutes % 10);
        formattedTime[13] = (byte)(48 + seconds / 10);
        formattedTime[15] = (byte)(48 + seconds % 10);
        return formattedTime;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            byte[] tmpArr = new byte[8];
            int hours = (raw[1] - 48) * 1000;
            hours += (raw[3] - 48) * 100;
            hours += (raw[5] - 48) * 10;
            hours += raw[7] - 48;
            tmpArr[0] = HighTime_C[hours %= 24];
            tmpArr[1] = LowTime_C[hours];
            tmpArr[2] = 58;
            tmpArr[3] = raw[9];
            tmpArr[4] = raw[11];
            tmpArr[5] = 58;
            tmpArr[6] = raw[13];
            tmpArr[7] = raw[15];
            result = new String(tmpArr);
        }
        return result;
    }
}

