/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private char[] charBuf = new char[4096];
    private byte[] byteBuf;
    private int bufPos = 0;
    private int bufExtent = 0;
    private boolean atEnd = false;
    private boolean sevenbit = false;

    public ReaderInputStream(Reader reader, boolean sevenbit) {
        this.reader = reader;
        this.sevenbit = sevenbit;
    }

    public int available() {
        int result = this.bufExtent - this.bufPos;
        return result;
    }

    public void close() throws IOException {
        this.bufPos = 0;
        this.bufExtent = 0;
        this.reader.close();
    }

    public int read() throws IOException {
        if (this.bufPos >= this.bufExtent) {
            this.fillBuffer();
        }
        byte result = this.byteBuf[this.bufPos];
        ++this.bufPos;
        return result;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int bytesCopied = 0;
        boolean atEnd = false;
        while (len > 0 && !atEnd) {
            if (this.bufPos >= this.bufExtent) {
                this.fillBuffer();
            }
            if (this.bufPos >= this.bufExtent) break;
            int copySize = Math.min(len, this.bufExtent - this.bufPos);
            System.arraycopy(this.byteBuf, this.bufPos, buf, off, copySize);
            this.bufPos += copySize;
            off += copySize;
            len -= copySize;
            bytesCopied += copySize;
            atEnd = this.atEnd;
        }
        if (bytesCopied == 0) {
            bytesCopied = -1;
        }
        return bytesCopied;
    }

    private void fillBuffer() throws IOException {
        this.bufPos = 0;
        this.bufExtent = 0;
        int charsRead = this.reader.read(this.charBuf);
        if (charsRead < this.charBuf.length) {
            this.atEnd = true;
        }
        if (charsRead < 0) {
            return;
        }
        String converter = new String(this.charBuf, 0, charsRead);
        this.byteBuf = this.sevenbit ? StringUtil.bytes_ascii7bit(converter) : StringUtil.bytes_iso8859_1(converter);
        this.bufExtent = this.byteBuf.length;
    }

    public void reset() throws IOException {
        this.bufPos = 0;
        this.bufExtent = 0;
        this.reader.reset();
    }
}

