/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.AbstractSimpleGetval;
import com.sap.dbtech.util.ByteUtil;
import com.sap.dbtech.util.MessageTranslator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class GetvalCharByte
extends AbstractSimpleGetval
implements Blob {
    byte[] data;

    public GetvalCharByte(byte[] datavalue) {
        this.data = datavalue;
    }

    public long length() throws SQLException {
        return this.data.length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if ((long)length + pos - 1L > (long)this.data.length) {
            throw new SQLException(MessageTranslator.translate("error.invalid.blob.position", String.valueOf(pos)));
        }
        byte[] erg = new byte[length];
        try {
            System.arraycopy(this.data, (int)pos - 1, erg, 0, length);
        }
        catch (Exception e) {
            throw new SQLException(MessageTranslator.translate("error.invalid.blob.position", String.valueOf(pos)));
        }
        return erg;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data);
    }

    public final long position(byte[] pattern, long start) throws SQLException {
        if (start > Integer.MAX_VALUE || start < 1L) {
            throw SQLExceptionSapDB.generateSQLException("error.valueoverflow", new Integer(2));
        }
        long erg = ByteUtil.indexOf(this.data, pattern, (int)start - 1);
        return erg == -1L ? -1L : erg + 1L;
    }

    public final long position(Blob pattern, long start) throws SQLException {
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(patternBytes, start);
    }
}

