/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Traceable;
import com.sap.dbtech.vsp001.PartKind;
import java.io.PrintStream;

public abstract class SQLPacket
extends MemIndirection
implements Traceable {
    protected int segmOffs;
    protected int partOffs;
    protected static final int Alignment_C = 8;

    protected SQLPacket(StructuredMem rawPacket) {
        super(rawPacket);
    }

    protected final int aligned(int size) {
        int modResult = size % 8;
        if (modResult != 0) {
            size += 8 - modResult;
        }
        return size;
    }

    int dumpPart(PrintStream stream, int maxBuf, int partPos) {
        stream.println("       <PART ");
        stream.println("       partkind=\"" + PartKind.names[this.getInt1(partPos + 0)] + "\"");
        stream.println("       arg_count=\"" + this.getInt2(partPos + 2) + "\"");
        stream.println("       buflen=\"" + this.getInt4(partPos + 8) + "\"");
        stream.println("       bufsize=\"" + this.getInt4(partPos + 12) + "\"");
        stream.println("       partpos=\"" + partPos + "\"");
        int offset = partPos + 16;
        int dataLen = this.getInt4(partPos + 8);
        maxBuf = maxBuf == -1 ? dataLen : Math.min(maxBuf, dataLen);
        switch (this.getInt1(partPos + 0)) {
            case 18: {
                String[] valmodeMap = new String[]{"vm_datapart", "vm_alldata", "vm_lastdata", "vm_nodata", "vm_no_more_data", "vm_last_putval", "vm_data_trunc", "vm_close"};
                byte undef_signal = this.getInt1(offset + 0);
                byte info_set = this.getInt1(offset + 25);
                byte valmode = this.getInt1(offset + 28);
                stream.println("       <LONG_DESCRIPTOR ");
                stream.println("           undef_signal=\"" + undef_signal + (undef_signal == 256 ? " isNull" : " notNull") + "\"");
                stream.println("           maxlen      =\"" + this.getInt4(offset + 17) + "\"");
                stream.println("           intern_pos  =\"" + this.getInt4(offset + 21) + "\"");
                stream.print("           info_set    =\"");
                if (info_set == 0) {
                    stream.println("0xFFFFFFFF\"");
                } else {
                    stream.print("0x");
                    stream.print((info_set & 0x80) != 0 ? "B" : "F");
                    stream.print((info_set & 0x40) != 0 ? "B" : "F");
                    stream.print((info_set & 0x20) != 0 ? "B" : "F");
                    stream.print((info_set & 0x10) != 0 ? "B" : "F");
                    stream.print((info_set & 8) != 0 ? "B" : "F");
                    stream.print((info_set & 4) != 0 ? "B" : "F");
                    stream.print((info_set & 2) != 0 ? "B" : "F");
                    stream.println((info_set & 1) != 0 ? "B\"" : "F\"");
                }
                stream.println("           valmode     =\"" + valmode + " (" + valmodeMap[valmode] + ")\"");
                stream.println("           valind      =\"" + this.getInt2(offset + 29) + "\"");
                stream.println("           valpos      =\"" + this.getInt4(offset + 33) + "\"");
                stream.println("           vallen      =\"" + this.getInt4(offset + 37) + "\"");
                stream.println("       </LONG_DESCRIPTOR ");
                break;
            }
        }
        stream.println("       </PART> ");
        return this.aligned(16 + dataLen);
    }

    abstract int dumpSegment(PrintStream var1, int var2, int var3);

    public int partCount() {
        return this.mem.getInt2(this.segmOffs + 8);
    }

    public int segmCount() {
        return this.mem.getInt2(22);
    }

    public void traceOn(PrintStream stream) {
        this.traceOn(stream, -1);
    }

    public void traceOn(PrintStream stream, int maxBuf) {
        stream.println("<PACKECT ");
        stream.println("messcode=\"" + this.getInt1(0) + "\"");
        stream.println("mess swap=\"" + this.getInt1(1) + "\"");
        stream.println("application=\"" + this.getString(4, 8) + "\" >");
        stream.println("<! (used " + String.valueOf(this.getInt4(16)) + " of " + String.valueOf(this.getInt4(12)) + ")>");
        int segmCount = this.segmCount();
        int pos = 32;
        for (int i = 0; i < segmCount; ++i) {
            pos += this.dumpSegment(stream, maxBuf, pos);
        }
        stream.println("</PACKECT> <!=================End of packet >");
    }
}

