/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import java.util.ArrayList;

public class DBProcParameterInfo {
    public static final int ABAPTABLE = 1;
    public static final int STRUCTURE = 2;
    private int type;
    private String sqlTypeName;
    private String baseTypeName;
    private ArrayList typeElements;

    public DBProcParameterInfo(String datatype, int len, int dec) {
        if (datatype.equals("ABAPTABLE")) {
            this.type = 1;
            this.typeElements = new ArrayList();
        } else if (datatype.equals("STRUCTURE")) {
            this.type = 2;
            this.typeElements = new ArrayList();
        }
    }

    public void addStructureElement(String typeName, String codeType, int length, int precision, int offset, int asciiOffset, int unicodeOffset) {
        if (this.typeElements == null) {
            return;
        }
        this.typeElements.add(new StructureElement(typeName, codeType, length, precision, offset, asciiOffset, unicodeOffset));
    }

    public int getMemberCount() {
        return this.typeElements.size();
    }

    public int getType() {
        return this.type;
    }

    public StructureElement getMember(int index) {
        return (StructureElement)this.typeElements.get(index);
    }

    public String getSQLTypeName() {
        if (this.sqlTypeName == null) {
            StringBuffer typeBuffer = new StringBuffer();
            StringBuffer baseType = new StringBuffer();
            String close = ")";
            if (this.type == 1) {
                if (this.typeElements.size() == 1) {
                    StructureElement el = (StructureElement)this.typeElements.get(0);
                    if (el.typeName.equals("CHAR")) {
                        if (el.codeType.equals("ASCII")) {
                            this.sqlTypeName = "CHARACTER STREAM";
                        } else if (el.codeType.equals("BYTE")) {
                            this.sqlTypeName = "BYTE STREAM";
                        }
                    } else if (el.typeName.equals("WYDE")) {
                        this.sqlTypeName = "CHARACTER STREAM";
                    }
                    typeBuffer.append("STREAM(");
                } else {
                    typeBuffer.append("STREAM(STRUCTURE(");
                    close = "))";
                }
            } else {
                typeBuffer.append("STRUCTURE(");
            }
            for (int i = 0; i < this.typeElements.size(); ++i) {
                if (i != 0) {
                    baseType.append(", ");
                    typeBuffer.append(", ");
                }
                StructureElement el = (StructureElement)this.typeElements.get(i);
                typeBuffer.append(el.getSQLTypeName());
                baseType.append(el.getSQLTypeName());
            }
            typeBuffer.append(close);
            this.sqlTypeName = typeBuffer.toString();
            this.baseTypeName = baseType.toString();
        }
        return this.sqlTypeName;
    }

    public String getBaseTypeName() {
        return this.baseTypeName;
    }

    public static class StructureElement {
        public String typeName;
        public String codeType;
        public int length;
        public int precision;
        public int offset;
        public int asciiOffset;
        public int unicodeOffset;

        StructureElement(String typeName, String codeType, int length, int precision, int offset, int asciiOffset, int unicodeOffset) {
            this.typeName = typeName;
            this.codeType = codeType;
            this.length = length;
            this.precision = precision;
            this.offset = offset;
            this.asciiOffset = asciiOffset;
            this.unicodeOffset = unicodeOffset;
        }

        public String getSQLTypeName() {
            if (this.typeName.equals("CHAR")) {
                return this.typeName + "(" + this.length + ") " + this.codeType;
            }
            if (this.typeName.equals("FIXED")) {
                return this.typeName + "(" + this.length + ", " + this.precision + ")";
            }
            if (this.typeName.equals("BOOLEAN")) {
                return this.typeName;
            }
            return this.typeName + "(" + this.length + ")";
        }
    }
}

