/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.openai;

import com.dbeaver.model.ai.AICompletionJoinRule;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.gpt3.GPTCompletionEngine;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.preferences.AIConfiguratorDefault;
import org.jkiss.utils.CommonUtils;

public class OpenAIConfiguratorAdvanced
extends AIConfiguratorDefault {
    private Button sendForeignKeysCheck;
    private Button sendConstraintsCheck;
    private Button formatQueryCheck;
    private Combo joinTypeCombo;

    public void createControl(@NotNull Composite placeholder, GPTCompletionEngine object, @NotNull Runnable propertyChangeListener) {
        super.createControl(placeholder, object, propertyChangeListener);
    }

    protected void createCompletionSettings(Group group, Runnable propertyChangeListener) {
        this.sendForeignKeysCheck = UIUtils.createCheckbox((Composite)group, (String)"Send foreign keys information", (String)"Send foreign keys information to OpenAI. It makes better completion but consumes more tokens.", (boolean)false, (int)2);
        this.sendConstraintsCheck = UIUtils.createCheckbox((Composite)group, (String)"Send unique keys and indexes information", (String)"Send unique Keys and indexes information to OpenAI. It makes better completion but consumes more tokens.", (boolean)false, (int)2);
    }

    protected void createFormattingSettings(Composite settingsPanel, Runnable propertyChangeListener) {
        Group formattingGroup = UIUtils.createControlGroup((Composite)settingsPanel, (String)"Formatting", (int)2, (int)0, (int)5);
        formattingGroup.setLayoutData((Object)new GridData(770));
        this.formatQueryCheck = UIUtils.createCheckbox((Composite)formattingGroup, (String)"Format SQL query", (String)"Format generated SQL query. Uses database-default case.", (boolean)false, (int)2);
        this.joinTypeCombo = UIUtils.createLabelCombo((Composite)formattingGroup, (String)"Table join rule", (String)"join tables according to rule", (int)12);
        AICompletionJoinRule[] aICompletionJoinRuleArray = AICompletionJoinRule.values();
        int n = aICompletionJoinRuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AICompletionJoinRule jr = aICompletionJoinRuleArray[n2];
            this.joinTypeCombo.add(jr.getTitle());
            ++n2;
        }
        this.joinTypeCombo.select(0);
    }

    public void loadSettings(@NotNull AISettings aiSettings) {
        super.loadSettings(aiSettings);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.sendForeignKeysCheck.setSelection(store.getBoolean("ai.useForeignKeys"));
        this.sendConstraintsCheck.setSelection(store.getBoolean("ai.useConstraints"));
        this.formatQueryCheck.setSelection(store.getBoolean("ai.formatSqlQuery"));
        AICompletionJoinRule jr = (AICompletionJoinRule)CommonUtils.valueOf(AICompletionJoinRule.class, (String)store.getString("ai.joinRule"), (Enum)AICompletionJoinRule.DEFAULT);
        this.joinTypeCombo.select(jr.ordinal());
    }

    public void saveSettings(@NotNull AISettings settings) {
        super.saveSettings(settings);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ai.useForeignKeys", this.sendForeignKeysCheck.getSelection());
        store.setValue("ai.useConstraints", this.sendConstraintsCheck.getSelection());
        store.setValue("ai.formatSqlQuery", this.formatQueryCheck.getSelection());
        store.setValue("ai.joinRule", ((AICompletionJoinRule)CommonUtils.fromOrdinal(AICompletionJoinRule.class, (int)this.joinTypeCombo.getSelectionIndex())).name());
    }
}

