/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSQL;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class DynamoUpdateStatement
extends DynamoBaseStatement {
    @Nullable
    private DynamoTable table;
    @Nullable
    private DBSAttributeBase[] valueAttributes;
    @Nullable
    private DBSAttributeBase[] keyAttributes;
    @Nullable
    private Object[] rowValues;
    @Nullable
    private String statementText;

    public DynamoUpdateStatement(@NotNull DynamoSession session, @NotNull String statementText) {
        super(session);
        this.table = null;
        this.valueAttributes = null;
        this.keyAttributes = null;
        this.rowValues = null;
        this.statementText = statementText;
    }

    public DynamoUpdateStatement(@NotNull DynamoSession session, @NotNull DBCExecutionSource source, @NotNull DynamoTable table, @NotNull DBSAttributeBase[] updateAttributes, @NotNull DBSAttributeBase[] keyAttributes, @NotNull Object[] rowValues) {
        super(session, source);
        this.table = table;
        this.valueAttributes = updateAttributes;
        this.keyAttributes = keyAttributes;
        this.rowValues = rowValues;
        this.statementText = null;
    }

    public void setRowValues(@Nullable Object[] rowValues) {
        this.rowValues = rowValues;
    }

    @Nullable
    public String getQueryString() {
        return this.statementText != null ? this.statementText : (this.statementText = this.makeStatementText());
    }

    @NotNull
    private String makeStatementText() {
        LinkedHashMap<String, String> exprAttrNames = new LinkedHashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(DBUtils.getObjectFullName((DBPNamedObject)this.table, (DBPEvaluationContext)DBPEvaluationContext.DML));
        ArrayList<String> removeAttrs = new ArrayList<String>();
        LinkedHashMap<String, String> updateAttrs = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < this.valueAttributes.length) {
            DBSAttributeBase va = this.valueAttributes[i];
            String encodedAttrName = DynamoUpdateStatement.getEncodedAttrName(exprAttrNames, va, va.getName());
            Object attrValue = this.rowValues[i];
            if (DBUtils.isNullValue((Object)attrValue)) {
                removeAttrs.add(encodedAttrName);
            } else {
                updateAttrs.put(encodedAttrName, this.getEncodedValueId(i));
            }
            ++i;
        }
        sql.append("\n" + this.buildModifyExpressions(removeAttrs, updateAttrs));
        sql.append("\nWHERE ");
        try {
            boolean first = true;
            Map<String, AttributeValue> attrKey = this.getKeyValues(((DynamoSession)this.getSession()).getProgressMonitor());
            for (Map.Entry<String, AttributeValue> ae : attrKey.entrySet()) {
                if (!first) {
                    sql.append(" AND ");
                }
                first = false;
                sql.append(ae.getKey()).append(" = '").append(DynamoDBUtils.getRawAttributeValue((DynamoDataSource)this.table.getDataSource(), null, ae.getValue())).append("'");
            }
        }
        catch (DBException e) {
            sql.append(e.getMessage());
        }
        return sql.toString();
    }

    public boolean executeStatement() throws DBCException {
        DBRProgressMonitor monitor = ((DynamoSession)this.getSession()).getProgressMonitor();
        try {
            UpdateItemRequest uir;
            if (this.valueAttributes != null && this.table != null && this.rowValues != null && this.keyAttributes != null) {
                uir = this.prepareUpdateRequest(monitor);
            } else if (this.statementText != null) {
                uir = this.parseUpdateStatement();
            } else {
                throw new DBCException("Not enough information to prepare update request");
            }
            ((DynamoSession)this.getSession()).getDataSource().getClient().updateItem(uir);
            return false;
        }
        catch (DBException e) {
            if (e instanceof DBCException) {
                throw (DBCException)e;
            }
            throw new DBCException(GeneralUtils.getRootCause((Throwable)e), (DBCExecutionContext)((DynamoSession)this.getSession()).getExecutionContext());
        }
    }

    @NotNull
    private UpdateItemRequest prepareUpdateRequest(@NotNull DBRProgressMonitor monitor) throws DBException {
        Map<String, AttributeValue> attrKey = this.getKeyValues(monitor);
        LinkedHashMap<String, String> exprAttrNames = new LinkedHashMap<String, String>();
        LinkedHashMap<String, AttributeValue> exprAttrValues = new LinkedHashMap<String, AttributeValue>();
        ArrayList<String> removeAttrs = new ArrayList<String>();
        LinkedHashMap<String, String> updateAttrs = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < this.valueAttributes.length) {
            DBSAttributeBase va = this.valueAttributes[i];
            String encodedAttrName = DynamoUpdateStatement.getEncodedAttrName(exprAttrNames, va, va.getName());
            String encodedAttrValueId = this.getEncodedValueId(i);
            Object attrValue = this.rowValues[i];
            if (DBUtils.isNullValue((Object)attrValue)) {
                removeAttrs.add(encodedAttrName);
            } else {
                updateAttrs.put(encodedAttrName, encodedAttrValueId);
                exprAttrValues.put(encodedAttrValueId, DynamoDBUtils.getAttributeValueFromPOJO(attrValue));
            }
            ++i;
        }
        UpdateItemRequest.Builder uir = UpdateItemRequest.builder().tableName(this.table.getName()).key(attrKey).updateExpression(this.buildModifyExpressions(removeAttrs, updateAttrs));
        if (!exprAttrNames.isEmpty()) {
            uir.expressionAttributeNames(exprAttrNames);
        }
        if (!exprAttrValues.isEmpty()) {
            uir.expressionAttributeValues(exprAttrValues);
        }
        return (UpdateItemRequest)uir.build();
    }

    @NotNull
    private UpdateItemRequest parseUpdateStatement() throws DBException {
        Statement statement = SQLSemanticProcessor.parseQuery((String)this.statementText);
        if (statement instanceof Update) {
            Update update = (Update)statement;
            if (!(update.getTable() != null && update.getFromItem() == null && update.getLimit() == null && update.getModifierPriority() == null && CommonUtils.isEmpty((Collection)update.getJoins()) && CommonUtils.isEmpty((Collection)update.getOrderByElements()) && CommonUtils.isEmpty((Collection)update.getReturningExpressionList()) && CommonUtils.isEmpty((Collection)update.getStartJoins()) && CommonUtils.isEmpty((Collection)update.getWithItemsList()) && update.getUpdateSets().size() != 0)) {
                throw new DBCException("Unsupported SQL query");
            }
            DynamoTable table = this.getDynamoTable(update.getTable().getName());
            UpdateItemRequest.Builder uir = UpdateItemRequest.builder();
            uir.tableName(table.getName());
            Expression where = update.getWhere();
            DynamoSQL.RequestConditionsInfo condition = DynamoSQL.prepareMutationConditions(table, where);
            LinkedHashMap<String, String> exprAttrNames = new LinkedHashMap<String, String>();
            LinkedHashMap<String, AttributeValue> exprAttrValues = new LinkedHashMap<String, AttributeValue>();
            if (condition.getFilterExpression().length() > 0) {
                uir.conditionExpression(condition.getFilterExpression());
            }
            if (!condition.getExprAttrNames().isEmpty()) {
                exprAttrNames.putAll(condition.getExprAttrNames());
            }
            if (!condition.getExprAttrValues().isEmpty()) {
                exprAttrValues.putAll(condition.getExprAttrValues());
            }
            if (!condition.getKeyValues().isEmpty()) {
                uir.key(condition.getKeyValues());
            }
            ArrayList columns = new ArrayList();
            ArrayList exprs = new ArrayList();
            for (UpdateSet set : update.getUpdateSets()) {
                columns.addAll(set.getColumns());
                exprs.addAll(set.getExpressions());
            }
            ArrayList<String> removeAttrs = new ArrayList<String>();
            LinkedHashMap<String, String> updateAttrs = new LinkedHashMap<String, String>();
            int i = 0;
            while (i < columns.size()) {
                String rawAttrName = ((Column)columns.get(i)).getColumnName();
                DBSEntityAttribute existingAttrOrNull = table.getAttribute(((DynamoSession)this.getSession()).getProgressMonitor(), rawAttrName);
                String encodedAttrName = DynamoUpdateStatement.getEncodedAttrName(exprAttrNames, (DBSAttributeBase)existingAttrOrNull, rawAttrName);
                String encodedAttrValueId = this.getEncodedValueId(i);
                Object attrValue = DynamoSQL.parseValueExpression((Expression)exprs.get(i));
                if (DBUtils.isNullValue((Object)attrValue)) {
                    removeAttrs.add(encodedAttrName);
                } else {
                    updateAttrs.put(encodedAttrName, encodedAttrValueId);
                    exprAttrValues.put(encodedAttrValueId, DynamoDBUtils.getAttributeValueFromPOJO(attrValue));
                }
                ++i;
            }
            uir.updateExpression(this.buildModifyExpressions(removeAttrs, updateAttrs));
            if (exprAttrNames.size() > 0) {
                uir.expressionAttributeNames(exprAttrNames);
            }
            if (exprAttrValues.size() > 0) {
                uir.expressionAttributeValues(exprAttrValues);
            }
            return (UpdateItemRequest)uir.build();
        }
        throw new DBCException("This type of statement is not supported");
    }

    @NotNull
    private Map<String, AttributeValue> getKeyValues(@NotNull DBRProgressMonitor monitor) throws DBException {
        LinkedHashMap<String, AttributeValue> attrKey = new LinkedHashMap<String, AttributeValue>();
        int i = 0;
        while (i < this.keyAttributes.length) {
            DBSAttributeBase ka = this.keyAttributes[i];
            Object attrValue = this.rowValues[this.valueAttributes.length + i];
            if (attrValue instanceof DynamoDocument) {
                attrKey.putAll(((DynamoDocument)((Object)attrValue)).getKeyValues(monitor));
            } else {
                attrKey.put(ka.getName(), DynamoDBUtils.getAttributeValueFromPOJO(attrValue));
            }
            ++i;
        }
        return attrKey;
    }

    @NotNull
    private static String getEncodedAttrName(@NotNull Map<String, String> exprAttrNames, @Nullable DBSAttributeBase attr, @NotNull String rawAttrName) {
        DBSObject parentObj;
        String attrName = attr == null ? rawAttrName : attr.getName();
        String name = "#" + CommonUtils.escapeIdentifier((String)attrName);
        exprAttrNames.put(name, attrName);
        if (attr instanceof DBSObject && (parentObj = ((DBSObject)attr).getParentObject()) instanceof DBSAttributeBase) {
            DBSAttributeBase parentAttr = (DBSAttributeBase)parentObj;
            if (parentAttr instanceof DBDAttributeBinding && ((DBDAttributeBinding)parentAttr).isPseudoAttribute() || parentAttr.getDataKind() == DBPDataKind.DOCUMENT && parentObj.getParentObject() == null) {
                return name;
            }
            name = String.valueOf(DynamoUpdateStatement.getEncodedAttrName(exprAttrNames, parentAttr, null)) + "." + name;
        }
        return name;
    }

    @NotNull
    private String getEncodedValueId(int i) {
        return ":val" + i;
    }

    @Override
    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return null;
    }

    @Override
    public DynamoTable getSourceEntity() {
        return this.table;
    }

    @NotNull
    private String buildModifyExpressions(@NotNull List<String> removeAttributes, @NotNull Map<String, String> updateAttributes) {
        StringBuilder updateExpr = new StringBuilder();
        if (!removeAttributes.isEmpty()) {
            updateExpr.append(" REMOVE ").append(String.join((CharSequence)", ", removeAttributes));
        }
        if (!updateAttributes.isEmpty()) {
            updateExpr.append(" SET ");
            updateExpr.append(updateAttributes.keySet().stream().map(key -> String.valueOf(key) + " = " + (String)updateAttributes.get(key)).collect(Collectors.joining(", ")));
        }
        return updateExpr.toString();
    }
}

