/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.model.document.exec.DocumentResultSet;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class DynamoResultSet
extends DocumentResultSet<DynamoSession, DynamoBaseStatement> {
    private final List<Map<String, AttributeValue>> items;

    public DynamoResultSet(DynamoBaseStatement statement, ScanResponse scanResponse) {
        super((DBCStatement)statement);
        this.items = scanResponse.items();
    }

    public DynamoResultSet(DynamoBaseStatement statement, QueryResponse queryResponse) {
        super((DBCStatement)statement);
        this.items = queryResponse.items();
    }

    public DynamoSession getSession() {
        return (DynamoSession)((DynamoBaseStatement)this.statement).getSession();
    }

    public DynamoBaseStatement getSourceStatement() {
        return (DynamoBaseStatement)this.statement;
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        Map<String, AttributeValue> valueMap = this.items.get(this.itemNumber);
        if (index == 0) {
            return new DynamoDocument(this.getSession().getDataSource(), ((DynamoBaseStatement)this.statement).getSourceEntity(), valueMap);
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return new DynamoDocument(this.getSession().getDataSource(), ((DynamoBaseStatement)this.statement).getSourceEntity(), this.items.get(this.itemNumber));
    }

    public boolean nextRow() throws DBCException {
        if (this.items.size() - 1 > this.itemNumber) {
            ++this.itemNumber;
            return true;
        }
        return false;
    }
}

