/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.model.document.exec.DocumentResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class DynamoResultIterable
extends DocumentResultSet<DynamoSession, DynamoBaseStatement> {
    private final Iterator<?> results;
    private List<Map<String, AttributeValue>> lastItems;
    private long totalItems;
    private long limit;

    DynamoResultIterable(DynamoBaseStatement statement, Iterable<?> results, long limit) {
        super((DBCStatement)statement);
        this.results = results.iterator();
        this.limit = limit;
        this.lastItems = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchNextSegment() throws DBCException {
        try {
            if (!this.results.hasNext()) {
                this.lastItems = null;
                this.itemNumber = -1;
                return false;
            }
            Object nextBatch = this.results.next();
            if (nextBatch instanceof ScanResponse) {
                this.lastItems = ((ScanResponse)nextBatch).items();
                this.itemNumber = -1;
                return true;
            }
            if (nextBatch instanceof QueryResponse) {
                this.lastItems = ((QueryResponse)nextBatch).items();
                this.itemNumber = -1;
                return true;
            }
            throw new IllegalStateException("Unsupported results type: " + nextBatch);
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)((DynamoSession)this.getSession()).getExecutionContext());
        }
    }

    @NotNull
    private Object createDocument(Map<String, AttributeValue> valueMap) {
        return new DynamoDocument(((DynamoSession)this.getSession()).getDataSource(), ((DynamoBaseStatement)this.statement).getSourceEntity(), valueMap);
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        Map<String, AttributeValue> valueMap = this.lastItems.get(this.itemNumber);
        if (index == 0) {
            return this.createDocument(valueMap);
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return this.createDocument(this.lastItems.get(this.itemNumber));
    }

    public boolean nextRow() throws DBCException {
        if (this.limit > 0L && this.totalItems >= this.limit) {
            return false;
        }
        if (this.lastItems != null && this.lastItems.size() - 1 > this.itemNumber) {
            ++this.itemNumber;
            ++this.totalItems;
            return true;
        }
        if (!this.fetchNextSegment()) {
            return false;
        }
        return this.nextRow();
    }

    @NotNull
    public List<Object[]> getSampleRows(DBCSession session, int maxRows) throws DBCException {
        if (this.lastItems == null && !this.fetchNextSegment()) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> sample = new ArrayList<Object[]>();
        for (Map<String, AttributeValue> doc : this.lastItems) {
            sample.add(new Object[]{this.createDocument(doc)});
        }
        return sample;
    }
}

