/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSQL;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.model.document.data.DBAbstractDocument;
import com.dbeaver.model.document.data.DBMapValue;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;

public class DynamoPutStatement
extends DynamoBaseStatement {
    @Nullable
    private DynamoTable table;
    @Nullable
    private DBSAttributeBase[] valueAttributes;
    @Nullable
    private Object[] rowValues;
    @Nullable
    private String statementText;

    public DynamoPutStatement(@NotNull DynamoSession session, @NotNull String statementText) {
        super(session);
        this.table = null;
        this.valueAttributes = null;
        this.rowValues = null;
        this.statementText = statementText;
    }

    public DynamoPutStatement(@NotNull DynamoSession session, @NotNull DBCExecutionSource source, @NotNull DynamoTable table, @NotNull DBSAttributeBase[] updateAttributes, @NotNull Object[] rowValues) {
        super(session, source);
        this.table = table;
        this.valueAttributes = updateAttributes;
        this.rowValues = rowValues;
        this.statementText = null;
    }

    public void setRowValues(@Nullable Object[] rowValues) {
        this.rowValues = rowValues;
    }

    @Nullable
    public String getQueryString() {
        return this.statementText != null ? this.statementText : (this.statementText = this.makeStatementText());
    }

    @NotNull
    private String makeStatementText() {
        DBMapValue rootNode;
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(DBUtils.getObjectFullName((DBPNamedObject)this.table, (DBPEvaluationContext)DBPEvaluationContext.DML));
        if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
            rootNode = this.getRootNodeFormRow();
        } else {
            LinkedHashMap<String, Object> attrMap = new LinkedHashMap<String, Object>();
            int i = 0;
            while (i < this.valueAttributes.length) {
                attrMap.put(this.valueAttributes[i].getName(), this.rowValues[i]);
                ++i;
            }
            rootNode = new DBMapValue((DBPDataSource)((DynamoSession)this.connection).getDataSource(), attrMap);
        }
        for (Map.Entry ae : rootNode.getRawValue().entrySet()) {
            sql.append("\nADD ");
            sql.append((String)ae.getKey()).append(" = '").append(ae.getValue()).append("'");
        }
        return sql.toString();
    }

    public boolean executeStatement() throws DBCException {
        PutItemRequest pir;
        if (this.valueAttributes != null && this.table != null && this.rowValues != null) {
            pir = this.preparePutRequest();
        } else if (this.statementText != null) {
            pir = this.parseInsertStatement();
        } else {
            throw new DBCException("Not enough information to prepare put request");
        }
        ((DynamoSession)this.getSession()).getDataSource().getClient().putItem(pir);
        return false;
    }

    @NotNull
    private PutItemRequest preparePutRequest() {
        DBMapValue rootNode = null;
        if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
            rootNode = this.getRootNodeFormRow();
        }
        if (rootNode == null) {
            LinkedHashMap<String, Object> attrMap = new LinkedHashMap<String, Object>();
            int i = 0;
            while (i < this.valueAttributes.length) {
                attrMap.put(this.valueAttributes[i].getName(), this.rowValues[i]);
                ++i;
            }
            rootNode = new DBMapValue((DBPDataSource)((DynamoSession)this.connection).getDataSource(), attrMap);
        }
        Map<String, AttributeValue> o = DynamoDBUtils.makeDynamoDocument(rootNode);
        PutItemRequest pir = (PutItemRequest)PutItemRequest.builder().tableName(this.table.getName()).item(o).build();
        return pir;
    }

    @Nullable
    private DBMapValue<DynamoDataSource> getRootNodeFormRow() {
        DBMapValue rootNode = null;
        int i = this.rowValues.length - 1;
        while (i >= 0) {
            if (this.rowValues[i] instanceof DBAbstractDocument) {
                rootNode = ((DBAbstractDocument)this.rowValues[i]).getRootNode();
                break;
            }
            --i;
        }
        return rootNode;
    }

    @NotNull
    private PutItemRequest parseInsertStatement() throws DBCException {
        Statement statement = SQLSemanticProcessor.parseQuery((String)this.statementText);
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            if (!(insert.getTable() != null && insert.getModifierPriority() == null && insert.getItemsList() == null && CommonUtils.isEmpty((Collection)insert.getReturningExpressionList()) && CommonUtils.isEmpty((Collection)insert.getWithItemsList()) && CommonUtils.isEmpty((Collection)insert.getColumns()))) {
                throw new DBCException("Unsupported SQL query");
            }
            DynamoTable table = this.getDynamoTable(insert.getTable().getName());
            PutItemRequest.Builder uir = PutItemRequest.builder();
            uir.tableName(table.getName());
            LinkedHashMap<String, AttributeValue> attrMap = new LinkedHashMap<String, AttributeValue>();
            List columns = insert.getSetColumns();
            List exprs = insert.getSetExpressionList();
            int i = 0;
            while (i < columns.size()) {
                String rawAttrName = ((Column)columns.get(i)).getColumnName();
                Object attrValue = DynamoSQL.parseValueExpression((Expression)exprs.get(i));
                if (!DBUtils.isNullValue((Object)attrValue)) {
                    attrMap.put(rawAttrName, DynamoDBUtils.getAttributeValueFromPOJO(attrValue));
                }
                ++i;
            }
            DBMapValue rootNode = new DBMapValue((DBPDataSource)((DynamoSession)this.connection).getDataSource(), attrMap);
            uir.item(DynamoDBUtils.makeDynamoDocument((DBMapValue<DynamoDataSource>)rootNode));
            return (PutItemRequest)uir.build();
        }
        throw new DBCException("This type of statement is not supported");
    }

    @Override
    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return null;
    }

    @Override
    @Nullable
    public DynamoTable getSourceEntity() {
        return this.table;
    }
}

