/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.data;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.model.document.data.DBDocumentAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoDocumentValueHandler
implements DBDValueHandlerComposite {
    public static final DynamoDocumentValueHandler INSTANCE = new DynamoDocumentValueHandler();

    @NotNull
    public Class<Object> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/json";
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof Map || value instanceof DBDValue) {
            return value.toString();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new DynamoDocument((DynamoDataSource)session.getDataSource(), this.getDynamoTable(type), null);
        }
        if (object instanceof Map) {
            Map srcMap = (Map)object;
            LinkedHashMap<String, AttributeValue> ddbMap = new LinkedHashMap<String, AttributeValue>(srcMap.size());
            for (Map.Entry entry : srcMap.entrySet()) {
                ddbMap.put(entry.getKey().toString(), DynamoDBUtils.getAttributeValueFromPOJO(entry.getValue()));
            }
            return new DynamoDocument((DynamoDataSource)session.getDataSource(), this.getDynamoTable(type), ddbMap);
        }
        if (object instanceof DynamoDocument) {
            DynamoDocument srcDocument = (DynamoDocument)((Object)object);
            return copy ? srcDocument.copy() : srcDocument;
        }
        return object;
    }

    @Nullable
    private DynamoTable getDynamoTable(@NotNull DBSTypedObject type) {
        DBSEntity parentObject;
        DynamoTable table = null;
        DBSTypedObject entityAttribute = type;
        if (entityAttribute instanceof DBDAttributeBinding) {
            entityAttribute = ((DBDAttributeBinding)entityAttribute).getEntityAttribute();
        }
        if (entityAttribute instanceof DBDocumentAttribute && (parentObject = ((DBDocumentAttribute)entityAttribute).getParentObject()) instanceof DynamoTable) {
            table = (DynamoTable)parentObject;
        }
        return table;
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        return new DynamoDocument((DynamoDataSource)session.getDataSource(), null, null);
    }

    public void releaseValueObject(Object value) {
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        if (attribute.getDataKind() == DBPDataKind.DOCUMENT) {
            return new DBCLogicalOperator[0];
        }
        return new DBCLogicalOperator[]{DBCLogicalOperator.EQUALS, DBCLogicalOperator.NOT_EQUALS, DBCLogicalOperator.GREATER, DBCLogicalOperator.GREATER_EQUALS, DBCLogicalOperator.LESS, DBCLogicalOperator.LESS_EQUALS, DBCLogicalOperator.IN};
    }

    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object attributeValue = resultSet.getAttributeValue(0);
        return this.getValueFromObject(session, type, attributeValue, false, false);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, Object value) throws DBCException {
    }
}

