/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPInformationProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DynamoDataSourceProvider
implements DBPDataSourceProvider,
DBPInformationProvider {
    private static final Log log = Log.getLog(DynamoDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    public long getFeatures() {
        return 2L;
    }

    public DBPPropertyDescriptor[] getConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) throws DBException {
        return null;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String regionName = connectionInfo.getProviderProperty("regionName");
        return "dynamodb." + regionName + ".amazonaws.com";
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new DynamoDataSource(monitor, container);
    }

    @Nullable
    public String getObjectInformation(@NotNull DBPObject object, @NotNull String infoType) {
        if (object instanceof DBPDataSourceContainer && infoType.equals("targetAddress")) {
            DBPConnectionConfiguration connectionInfo = ((DBPDataSourceContainer)object).getConnectionConfiguration();
            return connectionInfo.getProviderProperty("regionName");
        }
        return null;
    }
}

