/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.AbsoluteBendpoint;
import org.eclipse.draw2dl.Bendpoint;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef3.ConnectionEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef3.handles.BendpointCreationHandle;
import org.eclipse.gef3.handles.BendpointHandle;
import org.eclipse.gef3.handles.BendpointMoveHandle;
import org.eclipse.gef3.requests.BendpointRequest;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.MoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.RemoveBendpointContext;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;

public abstract class BendpointEditPolicyFixed
extends SelectionHandlesEditPolicy
implements PropertyChangeListener {
    protected static final List<Bendpoint> NULL_CONSTRAINT = new ArrayList<Bendpoint>();
    protected List<?> originalConstraint;
    protected boolean isDeleting = false;
    private IConfigurationProviderInternal configurationProvider;
    protected static final Point ref1 = new Point();
    protected static final Point ref2 = new Point();

    public BendpointEditPolicyFixed(IConfigurationProviderInternal configurationProvider) {
        this.setConfigurationProvider(configurationProvider);
    }

    public void activate() {
        super.activate();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    protected List<BendpointHandle> createHandlesForAutomaticBendpoints() {
        ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 1) {
            list.add((BendpointHandle)new BendpointCreationHandle(connEP, 0, i));
            ++i;
        }
        return list;
    }

    protected List<BendpointHandle> createHandlesForUserBendpoints() {
        ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        List<Bendpoint> bendPoints = (List<Bendpoint>)this.getConnection().getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = NULL_CONSTRAINT;
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = bendPoints.get(0).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            if (this.checkCreateBendpointFeature()) {
                list.add((BendpointHandle)new BendpointCreationHandle(connEP, bendPointIndex, i));
            }
            if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                if (this.checkMoveAndRemoveBendpointFeature()) {
                    list.add((BendpointHandle)new BendpointMoveHandle(connEP, bendPointIndex, i + 1));
                }
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = bendPoints.get(bendPointIndex).getLocation();
                }
            }
            ++i;
        }
        return list;
    }

    protected List<BendpointHandle> createSelectionHandles() {
        List<Object> list = new ArrayList();
        boolean automaticallyBending = this.isAutomaticallyBending();
        list = automaticallyBending ? this.createHandlesForAutomaticBendpoints() : this.createHandlesForUserBendpoints();
        return list;
    }

    public void deactivate() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        super.deactivate();
    }

    protected void eraseConnectionFeedback(BendpointRequest request) {
        this.restoreOriginalConstraint();
        request.getSource().refresh();
        this.originalConstraint = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType()) || "create bendpoint".equals(request.getType())) {
            this.eraseConnectionFeedback((BendpointRequest)request);
        }
    }

    public Command getCommand(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            if (this.isDeleting) {
                return this.getDeleteBendpointCommand((BendpointRequest)request);
            }
            return this.getMoveBendpointCommand((BendpointRequest)request);
        }
        if ("create bendpoint".equals(request.getType())) {
            return this.getCreateBendpointCommand((BendpointRequest)request);
        }
        return null;
    }

    protected Connection getConnection() {
        return (Connection)((ConnectionEditPart)this.getHost()).getFigure();
    }

    protected abstract Command getCreateBendpointCommand(BendpointRequest var1);

    protected abstract Command getDeleteBendpointCommand(BendpointRequest var1);

    protected abstract Command getMoveBendpointCommand(BendpointRequest var1);

    protected boolean isAutomaticallyBending() {
        List constraint = (List)this.getConnection().getRoutingConstraint();
        PointList points = this.getConnection().getPoints();
        return points.size() > 2 && (constraint == null || constraint.isEmpty());
    }

    protected boolean lineContainsPoint(Point p1, Point p2, Point p) {
        int tolerance = 7;
        Rectangle rect = Rectangle.SINGLETON;
        rect.setSize(0, 0);
        rect.setLocation(p1.x, p1.y);
        rect.union(p2.x, p2.y);
        rect.expand(tolerance, tolerance);
        if (!rect.contains(p.x, p.y)) {
            return false;
        }
        double result = 0.0;
        if (p1.x != p2.x && p1.y != p2.y) {
            int v1x = p2.x - p1.x;
            int v1y = p2.y - p1.y;
            int v2x = p.x - p1.x;
            int v2y = p.y - p1.y;
            int numerator = v2x * v1y - v1x * v2y;
            int denominator = v1x * v1x + v1y * v1y;
            result = (numerator << 10) / denominator * numerator >> 10;
        }
        return result <= (double)(tolerance * tolerance);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getHost().getSelected() != 0) {
            this.addSelectionHandles();
        }
    }

    protected void restoreOriginalConstraint() {
        if (this.originalConstraint != null) {
            if (this.originalConstraint == NULL_CONSTRAINT) {
                this.getConnection().setRoutingConstraint(null);
            } else {
                this.getConnection().setRoutingConstraint(this.originalConstraint);
            }
        }
    }

    protected void saveOriginalConstraint() {
        this.originalConstraint = (List)this.getConnection().getRoutingConstraint();
        if (this.originalConstraint == null) {
            this.originalConstraint = NULL_CONSTRAINT;
        }
        this.getConnection().setRoutingConstraint(new ArrayList(this.originalConstraint));
    }

    protected void setReferencePoints(BendpointRequest request) {
        PointList points = this.getConnection().getPoints();
        int bpIndex = -1;
        List bendPoints = (List)this.getConnection().getRoutingConstraint();
        Point bp = ((Bendpoint)bendPoints.get(request.getIndex())).getLocation();
        double smallestDistance = -1.0;
        int i = 0;
        while (i < points.size()) {
            double dist = points.getPoint(i).getDistance(bp);
            if (smallestDistance == -1.0 || dist < smallestDistance) {
                bpIndex = i;
                smallestDistance = dist;
                if (smallestDistance == 0.0) break;
            }
            ++i;
        }
        points.getPoint(ref1, bpIndex - 1);
        this.getConnection().translateToAbsolute((Translatable)ref1);
        points.getPoint(ref2, bpIndex + 1);
        this.getConnection().translateToAbsolute((Translatable)ref2);
    }

    protected void showCreateBendpointFeedback(BendpointRequest request) {
        List<Bendpoint> constraint;
        Point p = new Point(request.getLocation());
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            constraint = this.getConnectionRoutingConstraint();
            constraint.add(request.getIndex(), (Bendpoint)bp);
        } else {
            constraint = this.getConnectionRoutingConstraint();
        }
        constraint.set(request.getIndex(), (Bendpoint)bp);
        this.getConnection().setRoutingConstraint(constraint);
    }

    protected void showDeleteBendpointFeedback(BendpointRequest request) {
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            List constraint = (List)this.getConnection().getRoutingConstraint();
            constraint.remove(request.getIndex());
            this.getConnection().setRoutingConstraint((Object)constraint);
        }
    }

    protected void showMoveBendpointFeedback(BendpointRequest request) {
        Point p = new Point(request.getLocation());
        if (!this.isDeleting) {
            this.setReferencePoints(request);
        }
        if (this.lineContainsPoint(ref1, ref2, p)) {
            if (!this.isDeleting) {
                this.isDeleting = true;
                this.eraseSourceFeedback((Request)request);
                this.showDeleteBendpointFeedback(request);
            }
            return;
        }
        if (this.isDeleting) {
            this.isDeleting = false;
            this.eraseSourceFeedback((Request)request);
        }
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        List<Bendpoint> constraint = this.getConnectionRoutingConstraint();
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        constraint.set(request.getIndex(), (Bendpoint)bp);
        this.getConnection().setRoutingConstraint(constraint);
    }

    public void showSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            this.showMoveBendpointFeedback((BendpointRequest)request);
        } else if ("create bendpoint".equals(request.getType())) {
            this.showCreateBendpointFeedback((BendpointRequest)request);
        }
    }

    protected IConfigurationProviderInternal getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected IFeatureProvider getFeatureProvider() {
        if (this.getConfigurationProvider() != null) {
            return this.getConfigurationProvider().getFeatureProvider();
        }
        return null;
    }

    private void setConfigurationProvider(IConfigurationProviderInternal configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    private boolean checkMoveAndRemoveBendpointFeature() {
        if (!(this.getConnection() instanceof FreeFormConnection)) {
            return true;
        }
        boolean ret = false;
        FreeFormConnection ffc = (FreeFormConnection)this.getConnection();
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)ffc)) {
            return ret;
        }
        ret = this.getFeatureProvider().getMoveBendpointFeature((IMoveBendpointContext)new MoveBendpointContext(null)) != null;
        ret = ret || this.getFeatureProvider().getRemoveBendpointFeature((IRemoveBendpointContext)new RemoveBendpointContext(ffc, null)) != null;
        return ret;
    }

    private boolean checkCreateBendpointFeature() {
        if (!(this.getConnection() instanceof FreeFormConnection)) {
            return true;
        }
        boolean ret = false;
        FreeFormConnection ffc = (FreeFormConnection)this.getConnection();
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)ffc)) {
            return ret;
        }
        ret = this.getFeatureProvider().getMoveBendpointFeature((IMoveBendpointContext)new MoveBendpointContext(null)) != null;
        return ret;
    }

    protected List<Bendpoint> getConnectionRoutingConstraint() {
        Object rawRoutingConstraint = this.getConnection().getRoutingConstraint();
        List ret = (List)rawRoutingConstraint;
        return ret;
    }
}

