/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts.directedit;

import org.eclipse.draw2dl.FigureUtilities;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.tools.CellEditorLocator;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.ui.platform.ICellEditorProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextCellLocator
implements CellEditorLocator {
    private IFigure figure;
    private IDirectEditingFeature directEditingFeature;
    private int initialWidth = -1;

    public TextCellLocator(IFigure figure, IDirectEditingFeature directEditingFeature) {
        this.figure = figure;
        this.directEditingFeature = directEditingFeature;
    }

    public void relocate(CellEditor celleditor) {
        Control control = celleditor.getControl();
        if (this.directEditingFeature.getEditingType() == 5) {
            org.eclipse.draw2dl.geometry.Rectangle rect = this.figure.getClientArea().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            Rectangle trim = ((Text)control).computeTrim(0, 0, 0, 0);
            rect.translate(trim.x, trim.y);
            rect.width += trim.width;
            rect.height += trim.height;
            int correction = 16;
            Text text = (Text)celleditor.getControl();
            Dimension d = FigureUtilities.getTextExtents((String)text.getText(), (Font)text.getFont());
            int widthToSet = Math.min(rect.width, d.width + correction);
            rect.x += (rect.width - widthToSet) / 2;
            rect.y += (rect.height - d.height) / 2;
            text.setBounds(rect.x, rect.y, widthToSet, d.height);
        } else if (this.directEditingFeature.getEditingType() == 1) {
            org.eclipse.draw2dl.geometry.Rectangle rect = this.figure.getBounds().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            if (this.directEditingFeature.stretchFieldToFitText()) {
                Text text = (Text)control;
                int widthHint = -1;
                if (text.getText().length() == 0) {
                    widthHint = 0;
                }
                Point pref = text.computeSize(widthHint, -1);
                if (this.initialWidth == -1) {
                    this.initialWidth = pref.x;
                }
                if (pref.x < this.initialWidth) {
                    pref.x = this.initialWidth;
                }
                control.setBounds(rect.x, rect.y, pref.x + 10, pref.y);
            } else {
                int height = control.getFont().getFontData()[0].getHeight();
                control.setBounds(rect.x + 2, rect.y + 2, rect.width - 4, height * 2);
            }
        } else if (this.directEditingFeature.getEditingType() == 3 || this.directEditingFeature.getEditingType() == 6) {
            org.eclipse.draw2dl.geometry.Rectangle rect = this.figure.getBounds().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            int minWidth = 80;
            if (rect.width > minWidth) {
                minWidth = rect.width;
            }
            if (this.directEditingFeature.stretchFieldToFitText()) {
                CCombo combo = (CCombo)control;
                Point pref = combo.computeSize(-1, -1);
                if (minWidth < pref.x) {
                    minWidth = pref.x;
                }
            }
            control.setBounds(rect.x, rect.y, minWidth, 14);
        } else if (this.directEditingFeature.getEditingType() == 9 && this.directEditingFeature instanceof ICellEditorProvider) {
            ICellEditorProvider cep = (ICellEditorProvider)this.directEditingFeature;
            cep.relocate(celleditor, this.figure);
        }
    }

    public IFigure getFigure() {
        return this.figure;
    }
}

