/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import org.eclipse.draw2dl.Bendpoint;
import org.eclipse.draw2dl.BendpointConnectionRouter;
import org.eclipse.draw2dl.ConnectionRouter;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef3.EditPart;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.parts.ConnectionEditPart;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;

public class FreeFormConnectionEditPart
extends ConnectionEditPart {
    public FreeFormConnectionEditPart(IConfigurationProviderInternal configurationProvider, Connection connection, EditPart contextParent) {
        super(configurationProvider, connection, contextParent);
    }

    @Override
    public IFigure createFigure() {
        IFigure ret = super.createFigure();
        if (ret instanceof org.eclipse.draw2dl.Connection) {
            org.eclipse.draw2dl.Connection draw2dConnection = (org.eclipse.draw2dl.Connection)ret;
            draw2dConnection.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        }
        return ret;
    }

    private void refreshBendpoints() {
        FreeFormConnection ffc = (FreeFormConnection)this.getConnection();
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)ffc)) {
            return;
        }
        ArrayList<Bendpoint> pointList = new ArrayList<Bendpoint>();
        EList bendpoints = ffc.getBendpoints();
        for (Point point : bendpoints) {
            Bendpoint draw2dBendPoint = DataTypeTransformation.toDraw2dBendPoint(point);
            pointList.add(draw2dBendPoint);
        }
        this.getConnectionFigure().setRoutingConstraint(pointList);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Connection Bendpoint Policy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionBendpointsEditPolicy());
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshBendpoints();
    }
}

