/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef3.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef3.palette.ConnectionCreationToolEntry;
import org.eclipse.gef3.palette.PaletteContainer;
import org.eclipse.gef3.palette.PaletteDrawer;
import org.eclipse.gef3.palette.PaletteEntry;
import org.eclipse.gef3.palette.PaletteGroup;
import org.eclipse.gef3.palette.PaletteRoot;
import org.eclipse.gef3.palette.PaletteSeparator;
import org.eclipse.gef3.palette.PaletteStack;
import org.eclipse.gef3.palette.ToolEntry;
import org.eclipse.gef3.requests.CreationFactory;
import org.eclipse.gef3.tools.AbstractTool;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.palette.IConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.ICreationToolEntry;
import org.eclipse.graphiti.palette.IObjectCreationToolEntry;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IPaletteSeparatorEntry;
import org.eclipse.graphiti.palette.IStackToolEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.IEclipseImageDescriptor;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.editor.GFConnectionCreationTool;
import org.eclipse.graphiti.ui.internal.editor.GFCreationTool;
import org.eclipse.graphiti.ui.internal.editor.GFMarqueeToolEntry;
import org.eclipse.graphiti.ui.internal.editor.GFPanningSelectionToolEntry;
import org.eclipse.graphiti.ui.internal.util.gef3.MultiCreationFactory;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.resource.ImageDescriptor;

public class GFPaletteRoot
extends PaletteRoot {
    private static boolean DND_FROM_PALETTE = true;
    private IDiagramTypeProvider diagramTypeProvider;

    public GFPaletteRoot(IDiagramTypeProvider diagramTypeProvider) {
        if (diagramTypeProvider == null) {
            throw new IllegalArgumentException("diagramTypeProvider must not be null");
        }
        this.diagramTypeProvider = diagramTypeProvider;
        this.updatePaletteEntries();
    }

    public void updatePaletteEntries() {
        IPaletteCompartmentEntry[] paletteCompartments;
        this.setDefaultEntry(null);
        ArrayList allEntries = new ArrayList(this.getChildren());
        for (PaletteEntry entry : allEntries) {
            this.remove(entry);
        }
        this.add((PaletteEntry)this.createModelIndependentTools());
        IToolBehaviorProvider currentToolBehaviorProvider = this.diagramTypeProvider.getCurrentToolBehaviorProvider();
        IPaletteCompartmentEntry[] iPaletteCompartmentEntryArray = paletteCompartments = currentToolBehaviorProvider.getPalette();
        int n = paletteCompartments.length;
        int n2 = 0;
        while (n2 < n) {
            IPaletteCompartmentEntry compartmentEntry = iPaletteCompartmentEntryArray[n2];
            PaletteDrawer drawer = new PaletteDrawer(compartmentEntry.getLabel(), this.getImageDescriptor(compartmentEntry));
            if (!compartmentEntry.isInitiallyOpen()) {
                drawer.setInitialState(1);
            }
            this.add((PaletteEntry)drawer);
            List toolEntries = compartmentEntry.getToolEntries();
            for (IToolEntry toolEntry : toolEntries) {
                if (toolEntry instanceof ICreationToolEntry) {
                    ICreationToolEntry creationToolEntry = (ICreationToolEntry)toolEntry;
                    PaletteEntry createTool = this.createTool(creationToolEntry);
                    if (createTool == null) continue;
                    drawer.add(createTool);
                    continue;
                }
                if (toolEntry instanceof IStackToolEntry) {
                    IStackToolEntry stackToolEntry = (IStackToolEntry)toolEntry;
                    PaletteStack stack = new PaletteStack(stackToolEntry.getLabel(), stackToolEntry.getDescription(), GraphitiUi.getImageService().getImageDescriptorForId(this.diagramTypeProvider.getProviderId(), stackToolEntry.getIconId()));
                    drawer.add((PaletteEntry)stack);
                    List creationToolEntries = stackToolEntry.getCreationToolEntries();
                    for (ICreationToolEntry creationToolEntry : creationToolEntries) {
                        PaletteEntry createTool = this.createTool(creationToolEntry);
                        if (createTool == null) continue;
                        stack.add(createTool);
                    }
                    continue;
                }
                if (!(toolEntry instanceof IPaletteSeparatorEntry)) continue;
                drawer.add((PaletteEntry)new PaletteSeparator());
            }
            ++n2;
        }
    }

    protected PaletteContainer createModelIndependentTools() {
        Object tool;
        PaletteGroup controlGroup = new PaletteGroup(Messages.GraphicsPaletteRoot_0_xmen);
        ArrayList<GFPanningSelectionToolEntry> entries = new ArrayList<GFPanningSelectionToolEntry>();
        IToolBehaviorProvider toolBehaviorProvider = this.diagramTypeProvider.getCurrentToolBehaviorProvider();
        if (toolBehaviorProvider.isShowSelectionTool()) {
            tool = new GFPanningSelectionToolEntry();
            entries.add((GFPanningSelectionToolEntry)((Object)tool));
            this.setDefaultEntry((ToolEntry)tool);
        }
        if (toolBehaviorProvider.isShowMarqueeTool()) {
            tool = new GFMarqueeToolEntry();
            entries.add((GFPanningSelectionToolEntry)((Object)tool));
        }
        controlGroup.addAll(entries);
        return controlGroup;
    }

    private PaletteEntry createTool(ICreationToolEntry creationToolEntry) {
        String label = creationToolEntry.getLabel();
        String description = creationToolEntry.getDescription();
        if (creationToolEntry instanceof IObjectCreationToolEntry) {
            IObjectCreationToolEntry objectCreationToolEntry = (IObjectCreationToolEntry)creationToolEntry;
            DefaultCreationFactory cf = new DefaultCreationFactory(objectCreationToolEntry.getCreateFeature(), ICreateFeature.class);
            DefaultCreationFactory template = DND_FROM_PALETTE ? cf : null;
            CombinedTemplateCreationEntry pe = new CombinedTemplateCreationEntry(label, description, (Object)template, (CreationFactory)cf, this.getImageDescriptor(creationToolEntry, true), this.getImageDescriptor(creationToolEntry, false));
            pe.setToolClass(GFCreationTool.class);
            return pe;
        }
        if (creationToolEntry instanceof IConnectionCreationToolEntry) {
            IConnectionCreationToolEntry connectionCreationToolEntry = (IConnectionCreationToolEntry)creationToolEntry;
            MultiCreationFactory multiCreationFactory = new MultiCreationFactory(connectionCreationToolEntry.getCreateConnectionFeatures());
            ConnectionCreationToolEntry pe = new ConnectionCreationToolEntry(label, description, (CreationFactory)multiCreationFactory, this.getImageDescriptor(creationToolEntry, true), this.getImageDescriptor(creationToolEntry, false));
            pe.setToolClass(GFConnectionCreationTool.class);
            if (!this.diagramTypeProvider.getCurrentToolBehaviorProvider().isStayActiveAfterExecution(connectionCreationToolEntry)) {
                pe.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, (Object)true);
            }
            return pe;
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(ICreationToolEntry creationToolEntry, boolean smallImage) {
        ImageDescriptor imageDescriptor = null;
        if (creationToolEntry instanceof IEclipseImageDescriptor) {
            imageDescriptor = ((IEclipseImageDescriptor)creationToolEntry).getImageDescriptor();
        } else {
            String iconId = smallImage ? creationToolEntry.getIconId() : creationToolEntry.getLargeIconId();
            imageDescriptor = GraphitiUi.getImageService().getImageDescriptorForId(this.diagramTypeProvider.getProviderId(), iconId);
        }
        return imageDescriptor;
    }

    private ImageDescriptor getImageDescriptor(IPaletteCompartmentEntry compartmentEntry) {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = compartmentEntry instanceof IEclipseImageDescriptor ? ((IEclipseImageDescriptor)compartmentEntry).getImageDescriptor() : GraphitiUi.getImageService().getImageDescriptorForId(this.diagramTypeProvider.getProviderId(), compartmentEntry.getIconId());
        return imageDescriptor;
    }

    private class DefaultCreationFactory
    implements CreationFactory {
        private Object obj;
        private Object objType;

        public DefaultCreationFactory(Object obj, Object objType) {
            this.obj = obj;
            this.objType = objType;
        }

        public Object getNewObject() {
            return this.obj;
        }

        public Object getObjectType() {
            return this.objType;
        }
    }
}

