/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.impl.PasteContext;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.action.AbstractPreDefinedAction;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PasteAction
extends AbstractPreDefinedAction {
    private static final String TEXT;
    private static final String TOOL_TIP;
    public static final String ACTION_ID;

    static {
        TOOL_TIP = TEXT = Messages.PasteAction_0_xfld;
        ACTION_ID = ActionFactory.PASTE.getId();
    }

    public PasteAction(IWorkbenchPart part, IConfigurationProvider configurationProvider) {
        super(part, configurationProvider);
        this.setId(ACTION_ID);
        this.setText(TEXT);
        this.setToolTipText(TOOL_TIP);
    }

    @Override
    public boolean isAvailable() {
        IPasteContext context = this.createPasteContext();
        IPasteFeature feature = this.getFeatureProvider().getPasteFeature(context);
        return feature != null;
    }

    protected boolean calculateEnabled() {
        IPasteContext context = this.createPasteContext();
        if (context.getPictogramElements() == null || context.getPictogramElements().length == 0) {
            return false;
        }
        IFeatureProvider featureProvider = this.getFeatureProvider();
        if (featureProvider == null) {
            return false;
        }
        IPasteFeature feature = featureProvider.getPasteFeature(context);
        return feature != null && feature.canPaste(context);
    }

    public void run() {
        IPasteContext context = this.createPasteContext();
        IFeatureProvider featureProvider = this.getFeatureProvider();
        IPasteFeature feature = featureProvider.getPasteFeature(context);
        if (feature != null) {
            GenericFeatureCommandWithContext command = new GenericFeatureCommandWithContext((IFeature)feature, (IContext)context);
            this.executeOnCommandStack((ICommand)command);
        }
    }

    private IPasteContext createPasteContext() {
        PictogramElement[] pes = this.getSelectedPictogramElements();
        PasteContext context = new PasteContext(pes);
        Point pasteLocation = new Point(-1, -1);
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        IDiagramContainerUI diagramContainer = null;
        diagramContainer = workbenchPart instanceof IDiagramContainerUI ? (IDiagramContainerUI)workbenchPart : (IDiagramContainerUI)workbenchPart.getAdapter(IDiagramContainerUI.class);
        if (diagramContainer != null) {
            pasteLocation = diagramContainer.getDiagramBehavior().calculateRealMouseLocation(diagramContainer.getDiagramBehavior().getMouseLocation());
            context.setLocation(pasteLocation.x, pasteLocation.y);
        }
        return context;
    }
}

