/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.sql;

import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.models.Server;
import com.dbeaver.cloud.azure.AzureCloudAbstractInstance;
import com.dbeaver.cloud.azure.AzureCloudService;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AzureCloudMySQLInstance
extends AzureCloudAbstractInstance {
    private final Server instance;

    private AzureCloudMySQLInstance(@NotNull AzureCloudSession session, @NotNull Server instance) {
        super(session, new AzureCloudZone(instance.region()));
        this.instance = instance;
    }

    @NotNull
    public static List<AzureCloudAbstractInstance> list(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session) throws DBException {
        AuthModelAzureCredentials credentials = session.getCredentials();
        MySqlManager manager = (MySqlManager)credentials.authenticate(monitor, AuthModelAzureCredentials.Resource.MANAGEMENT, MySqlManager::authenticate);
        return manager.servers().list().stream().map(server -> new AzureCloudMySQLInstance(session, (Server)server)).collect(Collectors.toList());
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.instance.fullyQualifiedDomainName();
    }

    @NotNull
    public String getNodeId() {
        return this.instance.id();
    }

    @NotNull
    public String getNodeName() {
        return this.instance.name();
    }

    @NotNull
    public String getCloudResourceId() {
        return this.instance.id();
    }

    @Override
    protected void setDataSourceConfiguration(@NotNull DBPConnectionConfiguration configuration) {
        configuration.setHostName(this.instance.fullyQualifiedDomainName());
        configuration.setHostPort("3306");
        configuration.setAuthModelId("azure_ad_mysql");
    }

    @Override
    @NotNull
    protected AzureCloudService getCloudService() {
        return AzureCloudService.MYSQL;
    }
}

