/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.dbeaver.cloud.azure.AzureCloud;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.cloud.azure.sql.AzureCloudMySQLFlexibleInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudMySQLInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudPostgresFlexibleInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudPostgresInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudSQLServerInstance;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AzureCloudExplorer
implements CPCloudExplorer<AzureCloudZone> {
    private final AzureCloud cloud;
    private final AzureCloudSession session;

    public AzureCloudExplorer(@NotNull AzureCloud cloud, @NotNull AzureCloudSession session) {
        this.cloud = cloud;
        this.session = session;
    }

    @NotNull
    public CPCloud<?, ?> getCloud() {
        return this.cloud;
    }

    @NotNull
    public CPDatabaseFolder[] getRootFolders(@NotNull DBRProgressMonitor monitor) {
        return new CPDatabaseFolder[0];
    }

    @NotNull
    public CPDatabaseNode[] getDatabaseInstances(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category) throws DBException {
        List<Object> instances;
        switch (serviceID) {
            case "sqlserver": {
                instances = AzureCloudSQLServerInstance.list(monitor, this.session);
                break;
            }
            case "postgresql": {
                instances = AzureCloudPostgresInstance.list(monitor, this.session);
                break;
            }
            case "postgresql-flexible": {
                instances = AzureCloudPostgresFlexibleInstance.list(monitor, this.session);
                break;
            }
            case "mysql": {
                instances = AzureCloudMySQLInstance.list(monitor, this.session);
                break;
            }
            case "mysql-flexible": {
                instances = AzureCloudMySQLFlexibleInstance.list(monitor, this.session);
                break;
            }
            default: {
                instances = List.of();
            }
        }
        return (CPDatabaseNode[])instances.toArray(CPDatabaseNode[]::new);
    }

    @Nullable
    public CPDatabaseNode getDatabaseInstance(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category, @NotNull AzureCloudZone zone, @NotNull String instanceId) throws DBException {
        return null;
    }

    public void refreshSession(@NotNull CPCloudSession cloudSession) {
    }
}

