/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.dbeaver.cloud.azure.AzureCloud;
import com.dbeaver.cloud.azure.AzureCloudService;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;

public abstract class AzureCloudAbstractInstance
implements CPDatabaseNode,
CPDatabaseInstance {
    private final AzureCloudSession session;
    private final AzureCloudZone zone;

    public AzureCloudAbstractInstance(@NotNull AzureCloudSession session, @NotNull AzureCloudZone zone) {
        this.session = session;
        this.zone = zone;
    }

    @NotNull
    public DBPDataSourceContainer createDataSourceContainer(DBRProgressMonitor monitor, DBPDataSourceRegistry dataSourceRegistry) throws DBException {
        DBPDriver driver = this.getCloudService().getInstanceDriver();
        DBPConnectionConfiguration configuration = new DBPConnectionConfiguration();
        this.setDataSourceConfiguration(configuration);
        AzureCloud cloud = this.session.getCloud();
        DataSourceDescriptor dataSource = new DataSourceDescriptor(dataSourceRegistry, (DBPDataSourceConfigurationStorage)cloud.getDataSourceStorage(), (DBPDataSourceOrigin)cloud.createOrigin(cloud, this.getZone(), this.getCloudResourceId()), this.getCloudResourceId(), driver, configuration);
        dataSource.setHidden(true);
        dataSource.setName(String.valueOf(driver.getName()) + " - " + this.getNodeDisplayName());
        dataSource.setSavePassword(!this.isDriverNeedsAuthentication());
        dataSourceRegistry.addDataSource((DBPDataSourceContainer)dataSource);
        return dataSource;
    }

    @Nullable
    public DBPImage getNodeIcon() {
        try {
            return this.getCloudService().getInstanceDriver().getIcon();
        }
        catch (DBException dBException) {
            return null;
        }
    }

    @NotNull
    public AzureCloudZone getZone() {
        return this.zone;
    }

    @Nullable
    public CPDatabaseFolder getFolder() {
        return null;
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.getNodeName();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    protected boolean isDriverNeedsAuthentication() {
        return false;
    }

    protected abstract void setDataSourceConfiguration(@NotNull DBPConnectionConfiguration var1) throws DBException;

    @NotNull
    protected abstract AzureCloudService getCloudService();
}

