/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.dbeaver.cloud.azure.AzureCloudConfiguration;
import com.dbeaver.cloud.azure.AzureCloudDataSourceOrigin;
import com.dbeaver.cloud.azure.AzureCloudDataSourceStorage;
import com.dbeaver.cloud.azure.AzureCloudExplorer;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.CPCloudSessionManager;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.util.LinkedHashMap;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSessionProviderService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AzureCloud
implements CPCloud<AzureCloudZone, AzureCloudSession>,
CPCloudSessionManager<AzureCloudSession, AzureCloudZone> {
    private static final Log log = Log.getLog(AzureCloud.class);
    private final AzureCloudConfiguration configuration;
    private final AzureCloudDataSourceStorage dataSourceStorage;

    public AzureCloud(@NotNull AzureCloudConfiguration configuration) {
        this.configuration = configuration;
        this.dataSourceStorage = new AzureCloudDataSourceStorage(this);
    }

    @Nullable
    public AzureCloudSession getActiveSession() {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        try {
            return (AzureCloudSession)workspace.getAuthContext().getSpaceSession((DBRProgressMonitor)new VoidProgressMonitor(), (SMAuthSpace)this, false);
        }
        catch (DBException e) {
            log.debug((Object)"Error retrieving cloud session", (Throwable)e);
            return null;
        }
    }

    public String testConnection(DBRProgressMonitor monitor) throws DBException {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        SMSessionProviderService service = (SMSessionProviderService)DBWorkbench.getService(SMSessionProviderService.class);
        if (service == null) {
            throw new DBException("Can't obtain session provider");
        }
        monitor.beginTask("Connecting to Azure", 1);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            AzureCloudSession session = (AzureCloudSession)workspace.getAuthContext().getSpaceSession(monitor, (SMAuthSpace)this, true);
            try {
                if (session == null) {
                    throw new DBException("Azure session not found");
                }
                AuthModelAzureCredentials credentials = session.getCredentials();
                SqlServerManager manager = (SqlServerManager)credentials.authenticate(monitor, AuthModelAzureCredentials.Resource.MANAGEMENT, SqlServerManager::authenticate);
                StringJoiner joiner = new StringJoiner("\n");
                for (SqlServer server : manager.sqlServers().list()) {
                    joiner.add(String.valueOf(server.name()) + ":");
                    for (SqlDatabase database : manager.sqlServers().databases().listBySqlServer(server)) {
                        joiner.add(" - " + database.name() + " (" + database.databaseId() + ")");
                    }
                }
                String string = joiner.toString();
                if (session != null) {
                    session.close();
                }
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public String refreshSession(DBRProgressMonitor monitor) {
        return null;
    }

    public void closeSession(DBRProgressMonitor monitor) {
    }

    @NotNull
    public AzureCloudDataSourceOrigin createOrigin(@NotNull AzureCloud cloud, @NotNull AzureCloudZone zone, @NotNull String resourceId) {
        CloudProviderDescriptor cloudProvider = CloudProviderRegistry.getInstance().getCloudProvider("azure");
        LinkedHashMap<String, Object> dsConfiguration = new LinkedHashMap<String, Object>();
        dsConfiguration.put("cloud-provider", cloudProvider.getId());
        dsConfiguration.put("cloud-id", cloud.getCloudId());
        dsConfiguration.put("cloud-zone-id", zone.getZoneId());
        dsConfiguration.put("azure-resource", resourceId);
        return new AzureCloudDataSourceOrigin(cloudProvider, dsConfiguration, null);
    }

    @NotNull
    public String getCloudId() {
        return CommonUtils.notEmpty((String)this.configuration.getCloudId());
    }

    @NotNull
    public String getName() {
        return CommonUtils.notEmpty((String)this.configuration.getCloudName());
    }

    @NotNull
    public AzureCloudZone[] getAllZones() {
        return new AzureCloudZone[0];
    }

    @NotNull
    public AzureCloudConfiguration getCloudConfiguration() {
        return this.configuration;
    }

    @NotNull
    public CPCloudExplorer<AzureCloudZone> createExplorer(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session) {
        return new AzureCloudExplorer(this, session);
    }

    public boolean isDatabaseServiceSupported(String serviceId) {
        return true;
    }

    @NotNull
    public AzureCloudDataSourceStorage getDataSourceStorage() {
        return this.dataSourceStorage;
    }
}

