/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.model.navigator.DBNCloudDataSourceNode;
import com.dbeaver.cloud.model.navigator.DBNCloudNode;
import com.dbeaver.cloud.model.navigator.DBNCloudsRootNode;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationEditDialog;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationEditPage;
import com.dbeaver.cloud.ui.explorer.CloudExplorerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.ui.dialogs.connection.ProjectSelectorPanel;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectDelete;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorLabelProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.utils.CommonUtils;

public class CloudExplorerDialog
extends AbstractPopupPanel {
    private DatabaseNavigatorTree explorerTree;
    private ProjectSelectorPanel projectSelector;
    private ToolItem addConfigItem;
    private ToolItem editConfigItem;
    private ToolItem deleteConfigItem;
    private Button addConnectionsButton;
    private transient Map<String, DBPDataSourceContainer> allInstances;

    public CloudExplorerDialog(Shell parent) {
        super(parent, CloudUIMessages.cloud_explorer_dialog_title);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)CloudExplorerDialog.class.getSimpleName());
    }

    protected Composite createDialogArea(Composite parent) {
        Composite group = super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 600;
        group.setLayoutData((Object)gd);
        this.createCloudBrowserPanel(group);
        this.createCloudButtons(group);
        this.refreshClouds(true);
        return group;
    }

    private void createCloudBrowserPanel(Composite group) {
        Composite composite = UIUtils.createComposite((Composite)group, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        this.createCloudBrowser(composite);
        ToolBar toolbar = new ToolBar(composite, 0x800200);
        toolbar.setLayoutData((Object)new GridData(2));
        new ToolItem(toolbar, 2).setControl((Control)new Label((Composite)toolbar, 0));
        this.addConfigItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"New...", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudConfigurationEditDialog dialog = new CloudConfigurationEditDialog(CloudExplorerDialog.this.getShell(), null);
                if (dialog.open() == 0) {
                    CloudExplorerDialog.this.refreshClouds(true);
                }
            }
        });
        this.editConfigItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"Edit...", (DBPImage)UIIcon.EDIT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBNCloudNode node = (DBNCloudNode)((StructuredSelection)CloudExplorerDialog.this.explorerTree.getViewer().getSelection()).getFirstElement();
                CloudConfigurationDescriptor descriptor = new CloudConfigurationDescriptor(node.getCloudProvider(), node.getCloud().getCloudConfiguration());
                CloudConfigurationEditDialog dialog = new CloudConfigurationEditDialog(CloudExplorerDialog.this.getShell(), descriptor);
                if (dialog.open() == 0) {
                    CloudExplorerDialog.this.refreshClouds(true);
                }
            }
        });
        this.deleteConfigItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"Delete", (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBNCloudNode node = (DBNCloudNode)((StructuredSelection)CloudExplorerDialog.this.explorerTree.getViewer().getSelection()).getFirstElement();
                CPCloudConfiguration configuration = node.getCloud().getCloudConfiguration();
                if (!this.confirmDeletion(configuration)) {
                    return;
                }
                CloudConfigurationDescriptor descriptor = new CloudConfigurationDescriptor(node.getCloudProvider(), node.getCloud().getCloudConfiguration());
                List<CloudConfigurationDescriptor> descriptors = CloudConfigurationDescriptor.getAllCloudConfigurations();
                descriptors.remove(descriptor);
                CloudConfigurationEditPage.saveConfigurations(descriptors);
                CloudExplorerDialog.this.refreshClouds(true);
            }

            private boolean confirmDeletion(@NotNull CPCloudConfiguration configuration) {
                ArrayList<DBPDataSourceContainer> dsList = new ArrayList<DBPDataSourceContainer>();
                for (DBPDataSourceContainer ds : DataSourceRegistry.getAllDataSources()) {
                    if (ds.isHidden() || !(ds.getOrigin() instanceof DataSourceOriginCloud) || !ds.getOrigin().getDisplayName().equals(configuration.getCloudName())) continue;
                    dsList.add(ds);
                }
                if (!dsList.isEmpty()) {
                    if (!UIUtils.confirmAction((Shell)CloudExplorerDialog.this.getShell(), (String)"Cannot delete configuration", (String)("Cloud configuration '" + configuration.getCloudName() + "' is used to connect to  " + dsList.size() + " datasource(s).\nDo you want to view and delete these connections?\n"))) {
                        return false;
                    }
                    return NavigatorHandlerObjectDelete.tryDeleteObjects((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), CloudExplorerUtils.getDataSourceNodes(dsList));
                }
                return UIUtils.confirmAction((Shell)CloudExplorerDialog.this.getShell(), (String)"Confirm configuration delete", (String)("Are you sure you want to delete cloud configuration '" + configuration.getCloudName() + "'?"));
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private void createCloudBrowser(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        DatabaseNavigatorTreeFilter navigatorFilter = new DatabaseNavigatorTreeFilter(){

            public boolean select(Object element) {
                return true;
            }

            public boolean filterFolders() {
                return false;
            }

            public boolean isLeafObject(Object object) {
                return object instanceof DBNDataSource;
            }

            public boolean filterObjectByPattern(Object object) {
                return object instanceof DBNCloudDataSourceNode;
            }
        };
        this.explorerTree = new DatabaseNavigatorTree(composite, (DBNNode)DBWorkbench.getPlatform().getNavigatorModel().getRoot(), 67586, false, (INavigatorFilter)navigatorFilter, CloudUIMessages.cloud_explorer_dialog_tree_filter_text){

            @NotNull
            protected DatabaseNavigatorLabelProvider createLabelProvider(DatabaseNavigatorTree tree) {
                return new CloudExplorerLabelProvider(tree);
            }
        };
        this.explorerTree.setLayoutData((Object)new GridData(1808));
        this.explorerTree.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof DBNProject);
            }
        });
        this.explorerTree.getViewer().getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)CloudExplorerDialog.this.explorerTree.getViewer().getSelection();
                boolean enabled = selection.size() == 1 && selection.getFirstElement() instanceof DBNCloudNode;
                CloudExplorerDialog.this.editConfigItem.setEnabled(enabled);
                CloudExplorerDialog.this.deleteConfigItem.setEnabled(enabled);
            }
        });
        NavigatorUtils.addDragAndDropSupport((Viewer)this.explorerTree.getViewer(), (boolean)true, (boolean)false);
        this.explorerTree.getViewer().addSelectionChangedListener(event -> {
            boolean hasDataSourceNodes = false;
            for (Object element : this.explorerTree.getViewer().getStructuredSelection()) {
                if (element instanceof DBNCloudDataSourceNode) {
                    hasDataSourceNodes = true;
                    continue;
                }
                hasDataSourceNodes = false;
                break;
            }
            this.addConnectionsButton.setEnabled(hasDataSourceNodes);
        });
        Tree treeControl = this.explorerTree.getViewer().getTree();
        treeControl.setHeaderVisible(true);
        treeControl.addPaintListener(e -> {
            if (treeControl.getItemCount() == 0) {
                UIUtils.drawMessageOverControl((Control)treeControl, (PaintEvent)e, (String)CloudUIMessages.cloud_explorer_dialog_message_over_choose_cloud, (int)0);
            }
        });
        this.createColumns(this.explorerTree.getViewer());
        UIUtils.setControlContextMenu((Control)treeControl, manager -> {
            DBNNode selectedNode = NavigatorUtils.getSelectedNode((ISelectionProvider)this.explorerTree.getViewer());
            if (selectedNode instanceof DBNCloudDataSourceNode) {
                DBPDataSourceContainer ds = this.getExistingDataSource((DBNCloudDataSourceNode)selectedNode);
                if (ds != null) {
                    manager.add((IAction)new ShowDataSourceAction(ds));
                } else {
                    manager.add((IAction)new AddDataSourceAction((DBNCloudDataSourceNode)selectedNode));
                }
                manager.add((IContributionItem)new Separator());
            }
            UIUtils.fillDefaultTreeContextMenu((IContributionManager)manager, (Tree)treeControl);
        });
        this.closeOnFocusLost(new Control[]{this.explorerTree, this.explorerTree.getViewer().getControl()});
        UIUtils.createInfoLabel((Composite)composite, (String)CloudUIMessages.cloud_explorer_dialog_tree_dnd_hint);
    }

    private void createCloudButtons(@NotNull Composite parent) {
        Composite buttonsGroup = UIUtils.createComposite((Composite)parent, (int)3);
        buttonsGroup.setLayoutData((Object)new GridData(768));
        this.projectSelector = new ProjectSelectorPanel(buttonsGroup, NavigatorUtils.getSelectedProject(), 1){

            protected void onProjectChange() {
                CloudExplorerDialog.this.allInstances = null;
                CloudExplorerDialog.this.explorerTree.getViewer().refresh();
            }
        };
        UIUtils.createEmptyLabel((Composite)buttonsGroup, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        this.addConnectionsButton = UIUtils.createDialogButton((Composite)buttonsGroup, (String)CloudUIMessages.cloud_explorer_dialog_button_add_to_project, (DBPImage)UIIcon.SQL_NEW_CONNECTION, (String)CloudUIMessages.cloud_explorer_dialog_button_add_to_project_tip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudExplorerDialog.this.addSelectedToProject();
            }
        });
        this.addConnectionsButton.setEnabled(false);
    }

    private void createColumns(TreeViewer viewer) {
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        ViewerColumnController columnController = new ViewerColumnController("projectExplorer", (ColumnViewer)viewer);
        columnController.setForceAutoSize(true);
        columnController.addColumn(CloudUIMessages.cloud_explorer_dialog_button_name, CloudUIMessages.cloud_explorer_dialog_button_name_tip, 16384, true, true, (CellLabelProvider)new CloudExplorerLabelProvider(this, this.explorerTree){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        columnController.addColumn(CloudUIMessages.cloud_explorer_dialog_button_region, CloudUIMessages.cloud_explorer_dialog_button_region_tip, 16384, true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof DBNCloudDataSourceNode) {
                    return ((DBNCloudDataSourceNode)element).getInstance().getZone().getName();
                }
                return null;
            }
        });
        UIUtils.asyncExec(() -> columnController.createColumns(true));
    }

    private void refreshClouds(boolean forceRefresh) {
        DBPProject project = NavigatorUtils.getSelectedProject();
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project);
        DBNCloudsRootNode cloudRootNode = (DBNCloudsRootNode)projectNode.getExtraNode(DBNCloudsRootNode.class);
        if (cloudRootNode != null) {
            if (forceRefresh) {
                cloudRootNode.refreshCloudList();
            }
            this.explorerTree.setInput((DBNNode)cloudRootNode);
            this.explorerTree.getViewer().getTree().notifyListeners(13, new Event());
            DBNCloudNode[] clouds = cloudRootNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            if (clouds.length == 1) {
                this.explorerTree.getViewer().expandToLevel(2);
            }
        }
    }

    private void addSelectedToProject() {
        ArrayList<DBNCloudDataSourceNode> dsNodes = new ArrayList<DBNCloudDataSourceNode>();
        for (Object element : this.explorerTree.getViewer().getStructuredSelection()) {
            if (!(element instanceof DBNCloudDataSourceNode)) continue;
            dsNodes.add((DBNCloudDataSourceNode)element);
        }
        if (!dsNodes.isEmpty()) {
            this.addNodesToProject(dsNodes);
            this.explorerTree.getCheckboxViewer().setCheckedElements(new Object[0]);
        }
    }

    private List<DBPDataSourceContainer> addNodesToProject(List<DBNCloudDataSourceNode> dsNodes) {
        if (!dsNodes.isEmpty()) {
            try {
                List<DBNDataSource> nodes;
                this.allInstances = null;
                List dsList = CPCloudUtils.createDataSourcesFromCloudNodes((DBPProject)this.projectSelector.getSelectedProject(), null, dsNodes);
                if (!dsList.isEmpty() && !(nodes = CloudExplorerUtils.getDataSourceNodes(dsList)).isEmpty()) {
                    DBNDataSource dsNode = nodes.get(0);
                    this.setModeless(false);
                    try {
                        CloudExplorerUtils.showNodeInNavigator((DBNDatabaseNode)dsNode);
                    }
                    finally {
                        this.setModeless(true);
                    }
                }
                this.explorerTree.getViewer().refresh();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error adding connections", "Error while creating connections from cloud explorer", (Throwable)e);
            }
        }
        return null;
    }

    private DBPDataSourceContainer getExistingDataSource(DBNCloudDataSourceNode element) {
        CPDatabaseNode instance = element.getInstance();
        String instanceId = instance.getCloudResourceId();
        if (!CommonUtils.isEmpty((String)instanceId)) {
            return this.getCreatedInstances().get(instanceId);
        }
        return null;
    }

    private Map<String, DBPDataSourceContainer> getCreatedInstances() {
        if (this.allInstances == null) {
            this.allInstances = new HashMap<String, DBPDataSourceContainer>();
            for (DBPDataSourceContainer ds : this.projectSelector.getSelectedProject().getDataSourceRegistry().getDataSources()) {
                DBPDataSourceOrigin origin;
                if (ds.isHidden() || !((origin = ds.getOrigin()) instanceof DataSourceOriginCloud)) continue;
                String resourceId = ((DataSourceOriginCloud)origin).getResourceId();
                this.allInstances.put(resourceId, ds);
            }
        }
        return this.allInstances;
    }

    private class AddDataSourceAction
    extends Action {
        private final DBNCloudDataSourceNode node;

        AddDataSourceAction(DBNCloudDataSourceNode node) {
            super("Add '" + node.getNodeName() + "' to project");
            this.node = node;
        }

        public void run() {
            CloudExplorerDialog.this.addNodesToProject(Collections.singletonList(this.node));
        }
    }

    private class CloudExplorerLabelProvider
    extends DatabaseNavigatorLabelProvider {
        CloudExplorerLabelProvider(DatabaseNavigatorTree tree) {
            super((Viewer)tree.getViewer());
        }

        public Color getForeground(Object element) {
            if (element instanceof DBNCloudDataSourceNode && CloudExplorerDialog.this.getExistingDataSource((DBNCloudDataSourceNode)element) != null) {
                return CloudExplorerDialog.this.explorerTree.getViewer().getControl().getDisplay().getSystemColor(18);
            }
            return super.getForeground(element);
        }
    }

    private static class ShowDataSourceAction
    extends Action {
        private final DBPDataSourceContainer dataSource;

        ShowDataSourceAction(DBPDataSourceContainer dataSource) {
            super("Show in database navigator");
            this.dataSource = dataSource;
        }

        public void run() {
            DBNDatabaseNode dsNode = DBNUtils.getNodeByObject((DBSObject)this.dataSource);
            if (dsNode == null) {
                return;
            }
            CloudExplorerUtils.showNodeInNavigator(dsNode);
            super.run();
        }
    }
}

