/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.CPCloudSessionManager;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CloudConfigurationEditorDescriptor;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.cloud.registry.CloudUIRegistry;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class CloudConfigurationEditPage
extends DialogPage {
    private static final String DATA_CLOUD_PROVIDER = "cloudProvider";
    private static final String DATA_CLOUD_CONFIGURATION = "cloudConfiguration";
    private final List<CloudConfigurationDescriptor> allConfigurations = CloudConfigurationDescriptor.getAllCloudConfigurations();
    private CTabFolder configFolder;
    private Text configurationNameText;
    private Composite editorPlaceholder;
    private CloudConfigurationDescriptor currentCloudConfig;
    private IObjectPropertyConfigurator<Object, CPCloudConfiguration> editorInstance;
    private Runnable propChangeListener;
    private boolean createConfiguration = true;

    public CloudConfigurationDescriptor getCurrentCloudConfig() {
        return this.currentCloudConfig;
    }

    public void setConfiguration(CloudConfigurationDescriptor currentCloudConfig) {
        this.currentCloudConfig = currentCloudConfig;
        this.createConfiguration = currentCloudConfig == null;
    }

    public void setPropChangeListener(Runnable propChangeListener) {
        this.propChangeListener = propChangeListener;
    }

    public void createControl(Composite parent) {
        this.createCloudEditGroup(parent);
    }

    private void createCloudEditGroup(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 600;
        composite.setLayoutData((Object)gd);
        this.configurationNameText = UIUtils.createLabelText((Composite)composite, (String)CloudUIMessages.cloud_conf_edit_page_configuration_name_text, null, (int)2048);
        this.configurationNameText.addModifyListener(e -> {
            if (this.propChangeListener != null) {
                this.propChangeListener.run();
            }
        });
        this.configFolder = new CTabFolder(composite, 2176);
        this.configFolder.setLayout((Layout)new GridLayout());
        this.configFolder.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(2, 1).create());
        this.configFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudConfigurationEditPage.this.currentCloudConfig = this.getOrCreateCloudConfiguration(CloudConfigurationEditPage.this.configFolder.getSelection());
                CloudConfigurationEditPage.this.showCloudConfiguration();
                if (CloudConfigurationEditPage.this.propChangeListener != null) {
                    CloudConfigurationEditPage.this.propChangeListener.run();
                }
            }

            @NotNull
            private CloudConfigurationDescriptor getOrCreateCloudConfiguration(@NotNull CTabItem item) {
                CloudConfigurationDescriptor cloudConfiguration = (CloudConfigurationDescriptor)item.getData(CloudConfigurationEditPage.DATA_CLOUD_CONFIGURATION);
                if (cloudConfiguration == null) {
                    CloudProviderDescriptor cloudProvider = (CloudProviderDescriptor)item.getData(CloudConfigurationEditPage.DATA_CLOUD_PROVIDER);
                    CPCloudConfigurationProvider cloudConfigProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(cloudProvider.getId());
                    cloudConfiguration = CloudConfigurationEditPage.this.createCloudConfiguration(cloudProvider, cloudConfigProvider);
                    item.setData(CloudConfigurationEditPage.DATA_CLOUD_CONFIGURATION, (Object)cloudConfiguration);
                }
                return cloudConfiguration;
            }
        });
        this.editorPlaceholder = new Composite((Composite)this.configFolder, 0);
        this.editorPlaceholder.setLayoutData((Object)new GridData(1808));
        this.editorPlaceholder.setLayout((Layout)new FillLayout());
        for (CloudProviderDescriptor provider : CloudProviderRegistry.getInstance().getCloudProviders()) {
            if (this.currentCloudConfig != null && this.currentCloudConfig.getCloudProvider() != provider) continue;
            CTabItem item = new CTabItem(this.configFolder, 0);
            item.setControl((Control)this.editorPlaceholder);
            item.setData(DATA_CLOUD_PROVIDER, (Object)provider);
            item.setText(provider.getDisplayName());
            item.setToolTipText(provider.getDescription());
            item.setImage(DBeaverIcons.getImage((DBPImage)provider.getIcon()));
            if (this.currentCloudConfig != null && this.currentCloudConfig.getCloudProvider() == provider) {
                item.setData(DATA_CLOUD_CONFIGURATION, (Object)this.currentCloudConfig);
            }
            if (this.currentCloudConfig == null || this.currentCloudConfig.getCloudProvider() != provider) continue;
            this.configFolder.setSelection(item);
        }
        if (this.configFolder.getSelection() == null) {
            this.configFolder.setSelection(0);
        }
        this.resetToDefaults();
        this.setControl((Control)composite);
        this.configFolder.setFocus();
    }

    void resetToDefaults() {
        this.showCloudConfiguration();
        if (this.propChangeListener != null) {
            this.propChangeListener.run();
        }
    }

    private CloudConfigurationDescriptor createCloudConfiguration(CloudProviderDescriptor cloudProvider, CPCloudConfigurationProvider<?> cfgProvider) {
        CloudConfigurationDescriptor cfg = new CloudConfigurationDescriptor(cloudProvider, cfgProvider.createConfiguration());
        cfg.getConfiguration().setCloudId(UUID.randomUUID().toString());
        cfg.getConfiguration().setCloudName(this.generateCloudName(cfg));
        return cfg;
    }

    @NotNull
    public String generateCloudName(CloudConfigurationDescriptor cfg) {
        return this.generateCloudName(cfg.getCloudProvider());
    }

    @NotNull
    public String generateCloudName(CloudProviderDescriptor cfg) {
        int i = 0;
        while (true) {
            String name = String.valueOf(cfg.getLabel()) + " configuration";
            if (i > 0) {
                name = String.valueOf(name) + " (" + i + ")";
            }
            for (CloudConfigurationDescriptor ccd : this.allConfigurations) {
                if (!name.equals(ccd.getConfiguration().getCloudName())) continue;
                name = null;
                break;
            }
            if (name != null) {
                return name;
            }
            ++i;
        }
    }

    private void showCloudConfiguration() {
        UIUtils.disposeChildControls((Composite)this.editorPlaceholder);
        if (this.currentCloudConfig == null) {
            CloudProviderDescriptor cloudProvider = CloudConfigurationEditPage.getActiveCloudProvider();
            CPCloudConfigurationProvider<?> cfgProvider = CloudConfigurationEditPage.getCloudConfigurationProvider(null);
            if (cloudProvider != null && cfgProvider != null) {
                this.currentCloudConfig = this.createCloudConfiguration(cloudProvider, cfgProvider);
            }
        }
        if (this.currentCloudConfig == null) {
            return;
        }
        this.configurationNameText.setText(CommonUtils.notEmpty((String)this.currentCloudConfig.getConfiguration().getCloudName()));
        CloudConfigurationEditorDescriptor cloudEditorDescriptor = CloudUIRegistry.getInstance().getConfigurationEditor(this.currentCloudConfig.getCloudProvider());
        if (cloudEditorDescriptor == null) {
            DBWorkbench.getPlatformUI().showError("No cloud configuration editor", "No configuration editor for cloud '" + this.currentCloudConfig.getCloudProvider().getId() + "'");
            return;
        }
        try {
            this.editorInstance = cloudEditorDescriptor.createInstance();
            this.editorInstance.createControl(this.editorPlaceholder, (Object)this.currentCloudConfig, this.propChangeListener);
            this.editorInstance.loadSettings((Object)this.currentCloudConfig.getConfiguration());
            this.editorPlaceholder.layout(true, true);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Editor error", "Error while creating configuration editor", (Throwable)e);
            return;
        }
    }

    private void saveConfigurationFromUI() {
        if (this.currentCloudConfig != null && this.editorInstance != null && this.editorInstance.isComplete()) {
            CPCloudConfiguration cfg = this.currentCloudConfig.getConfiguration();
            cfg.setCloudName(this.configurationNameText.getText());
            this.editorInstance.saveSettings((Object)cfg);
        }
    }

    private static CPCloudConfigurationProvider<?> getCloudConfigurationProvider(CloudConfigurationDescriptor config) {
        CPCloudConfigurationProvider ccProvider;
        if (config == null) {
            CloudProviderDescriptor cloudProvider = CloudConfigurationEditPage.getActiveCloudProvider();
            if (cloudProvider == null) {
                return null;
            }
            ccProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(cloudProvider.getId());
            if (ccProvider == null) {
                DBWorkbench.getPlatformUI().showError("Invalid configuration provider", "Error creating cloud configuration provider");
                return null;
            }
        } else {
            ccProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(config.getCloudProvider().getId());
        }
        return ccProvider;
    }

    private static CloudProviderDescriptor getActiveCloudProvider() {
        List cloudProviders = CloudProviderRegistry.getInstance().getCloudProviders();
        if (cloudProviders.isEmpty()) {
            DBWorkbench.getPlatformUI().showError("No cloud configuration provider", "No cloud configuration providers found");
            return null;
        }
        return (CloudProviderDescriptor)cloudProviders.get(0);
    }

    public void saveConfigurations() {
        this.saveConfigurationFromUI();
        if (this.createConfiguration) {
            this.allConfigurations.add(this.currentCloudConfig);
            this.createConfiguration = false;
        }
        CloudConfigurationEditPage.saveConfigurations(this.allConfigurations);
    }

    public static void saveConfigurations(@NotNull Collection<CloudConfigurationDescriptor> configurations) {
        CPCloudConfigurationProvider ccp;
        LinkedHashMap<CPCloudConfigurationProvider, List> configMap = new LinkedHashMap<CPCloudConfigurationProvider, List>();
        for (CloudConfigurationDescriptor ccd : configurations) {
            ccp = CloudConfigurationEditPage.getCloudConfigurationProvider(ccd);
            if (ccp == null) continue;
            configMap.computeIfAbsent(ccp, c -> new ArrayList()).add(ccd.getConfiguration());
        }
        for (CPCloudConfigurationProvider ccpc : configMap.keySet()) {
            List list = (List)configMap.get(ccpc);
            ccpc.saveConfigurations((Collection)list);
            for (CPCloudConfiguration cc : list) {
                CPCloudSession activeSession;
                CPCloud cloud;
                if (cc.getCloudId() == null || !((cloud = CPCloudUtils.getCloud(null, (String)cc.getCloudId(), null)) instanceof CPCloudSessionManager) || (activeSession = ((CPCloudSessionManager)cloud).getActiveSession()) == null) continue;
                activeSession.closeSession();
                try {
                    DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession((DBRProgressMonitor)new VoidProgressMonitor(), (SMAuthSpace)cloud, true);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Session refresh", "Error reopening cloud session", (Throwable)e);
                }
            }
        }
        for (CPCloudConfigurationProvider ccpc : CloudProviderRegistry.getInstance().getConfigurationProviders()) {
            ccp = CloudProviderRegistry.getInstance().getConfigurationProvider(ccpc.getId());
            if (configMap.containsKey(ccp)) continue;
            ccp.saveConfigurations(Collections.emptyList());
        }
    }

    public boolean isComplete() {
        return this.editorInstance != null && this.editorInstance.isComplete();
    }
}

