/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.registry.CloudConfigurationEditorDescriptor;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;

public class CloudUIRegistry {
    private static final Log log = Log.getLog(CloudUIRegistry.class);
    private static final String CLOUD_CONFIGURATION_EDITOR_EXTENSION_ID = "com.dbeaver.cloud.ui.configuratorEditor";
    private static final String TAG_CONFIGURATION_EDITOR = "editor";
    private static CloudUIRegistry instance;
    private List<CloudConfigurationEditorDescriptor> configurationEditors = new ArrayList<CloudConfigurationEditorDescriptor>();

    public static synchronized CloudUIRegistry getInstance() {
        if (instance == null) {
            instance = new CloudUIRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private CloudUIRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(CLOUD_CONFIGURATION_EDITOR_EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_CONFIGURATION_EDITOR.equals(ext.getName())) {
                CloudConfigurationEditorDescriptor editorDescriptor = new CloudConfigurationEditorDescriptor(ext);
                this.configurationEditors.add(editorDescriptor);
            }
            ++n2;
        }
    }

    public List<CloudConfigurationEditorDescriptor> getConfigurationEditors() {
        return this.configurationEditors;
    }

    public CloudConfigurationEditorDescriptor getConfigurationEditor(CloudProviderDescriptor cloudProvider) {
        for (CloudConfigurationEditorDescriptor editor : this.configurationEditors) {
            if (!CommonUtils.equalObjects((Object)editor.getCloudId(), (Object)cloudProvider.getId())) continue;
            return editor;
        }
        return null;
    }
}

