/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.jdbc41.future;

import com.simba.athena.dsi.core.interfaces.IStatement;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.jdbc.common.SConnection;
import com.simba.athena.jdbc.common.future.SStatement;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.utilities.JDBCVersion;
import java.sql.SQLException;

public class S41Statement
extends SStatement {
    public S41Statement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        this(iStatement, sConnection, n, JDBCVersion.JDBC41);
    }

    protected S41Statement(IStatement iStatement, SConnection sConnection, int n, JDBCVersion jDBCVersion) throws SQLException {
        super(iStatement, sConnection, n);
        this.m_jdbcVersion = jDBCVersion;
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

