/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.model;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.auth.AWSStaticCredentialsProvider;
import com.simba.athena.amazonaws.auth.BasicSessionCredentials;
import com.simba.athena.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.simba.athena.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.simba.athena.amazonaws.auth.profile.ProfilesConfigFile;
import com.simba.athena.amazonaws.auth.profile.internal.BasicProfile;
import com.simba.athena.amazonaws.auth.profile.internal.ProfileStaticCredentialsProvider;
import com.simba.athena.amazonaws.client.builder.AwsClientBuilder;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.simba.athena.amazonaws.services.securitytoken.model.Credentials;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.iamsupport.IPlugin;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.model.IamSupportSettings;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginProfilesConfiguration
extends ProfilesConfigFile {
    private static final String CREDENTIAL_PROCESS = "credential_process";
    private Map<String, CredentialsHolder> m_credentialCache = new ConcurrentHashMap<String, CredentialsHolder>();
    private IamSupportSettings m_settings;

    public PluginProfilesConfiguration(IamSupportSettings iamSupportSettings) {
        this.m_settings = iamSupportSettings;
    }

    @Override
    public CredentialsHolder getCredentials(String string) {
        Object object;
        CredentialsHolder credentialsHolder = this.m_credentialCache.get(string);
        if (credentialsHolder != null && !credentialsHolder.isExpired()) {
            return credentialsHolder;
        }
        Map<String, BasicProfile> map = this.getAllBasicProfiles();
        BasicProfile basicProfile = map.get(string);
        if (basicProfile == null) {
            throw new SdkClientException("No AWS profile named '" + string + "'");
        }
        if (basicProfile.isRoleBasedProfile()) {
            String string2 = basicProfile.getRoleSourceProfile();
            if (null != string2) {
                CredentialsHolder credentialsHolder2 = this.getCredentials(string2);
                AWSStaticCredentialsProvider aWSStaticCredentialsProvider = new AWSStaticCredentialsProvider(credentialsHolder2);
                credentialsHolder = this.assumeRole(basicProfile, aWSStaticCredentialsProvider);
                credentialsHolder.setMetadata(credentialsHolder2.getMetadata());
                this.m_credentialCache.put(string, credentialsHolder);
                return credentialsHolder;
            }
            InstanceProfileCredentialsProvider instanceProfileCredentialsProvider = InstanceProfileCredentialsProvider.getInstance();
            credentialsHolder = this.assumeRole(basicProfile, instanceProfileCredentialsProvider);
            this.m_credentialCache.put(string, credentialsHolder);
            return credentialsHolder;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = basicProfile.getPropertyValue("plugin_name");
        if (StringUtils.isNullOrEmpty(string6) && StringUtils.isNullOrEmpty(string6 = basicProfile.getPropertyValue("AwsCredentialsProviderClass"))) {
            string6 = basicProfile.getPropertyValue("aws_credentials_provider_class");
        }
        if (!StringUtils.isNullOrEmpty(string6)) {
            try {
                object = Class.forName(string6).asSubclass(AWSCredentialsProvider.class);
                AWSCredentialsProvider aWSCredentialsProvider = (AWSCredentialsProvider)((Class)object).newInstance();
                if (aWSCredentialsProvider instanceof IPlugin) {
                    String string7;
                    IPlugin iPlugin = (IPlugin)aWSCredentialsProvider;
                    Map<String, String> map2 = basicProfile.getProperties();
                    for (Map.Entry<String, String> entry : map2.entrySet()) {
                        string7 = entry.getKey().toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(string7)) continue;
                        String string8 = entry.getValue();
                        iPlugin.addParameter(string7, string8);
                        if ("DbUser".equalsIgnoreCase(string7)) {
                            string3 = string8;
                            continue;
                        }
                        if ("DbGroups".equalsIgnoreCase(string7)) {
                            string5 = string8;
                            continue;
                        }
                        if (!"AutoCreate".equalsIgnoreCase(string7)) continue;
                        string4 = string8;
                    }
                    for (Map.Entry<String, String> entry : this.m_settings.m_pluginArgs.entrySet()) {
                        string7 = entry.getKey().toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(string7)) continue;
                        iPlugin.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                credentialsHolder = CredentialsHolder.newInstance(aWSCredentialsProvider.getCredentials());
            }
            catch (InstantiationException instantiationException) {
                throw new SdkClientException("Invalid plugin: '" + string6 + "'");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SdkClientException("Invalid plugin: '" + string6 + "'");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SdkClientException("Invalid plugin: '" + string6 + "'");
            }
        } else {
            object = basicProfile.getPropertyValue(CREDENTIAL_PROCESS);
            if (!StringUtils.isNullOrEmpty((String)object)) {
                AWSCredentials aWSCredentials = new ProfileCredentialsProvider(string).getCredentials();
                credentialsHolder = CredentialsHolder.newInstance(aWSCredentials);
            } else {
                AWSCredentials aWSCredentials = new ProfileStaticCredentialsProvider(basicProfile).getCredentials();
                credentialsHolder = CredentialsHolder.newInstance(aWSCredentials);
            }
        }
        object = credentialsHolder.getMetadata();
        if (null == object) {
            object = new CredentialsHolder.IamMetadata();
        }
        if (null != string3) {
            ((CredentialsHolder.IamMetadata)object).setDbUser(string3);
        }
        if (null != string4) {
            ((CredentialsHolder.IamMetadata)object).setAutoCreate(Boolean.valueOf(string4));
        }
        if (null != string5) {
            ((CredentialsHolder.IamMetadata)object).setDbGroups(string5);
        }
        credentialsHolder.setMetadata((CredentialsHolder.IamMetadata)object);
        this.m_credentialCache.put(string, credentialsHolder);
        return credentialsHolder;
    }

    private CredentialsHolder assumeRole(BasicProfile basicProfile, AWSCredentialsProvider aWSCredentialsProvider) {
        Object object;
        AWSSecurityTokenServiceClientBuilder aWSSecurityTokenServiceClientBuilder = AWSSecurityTokenServiceClientBuilder.standard();
        if (!StringUtils.isNullOrEmpty(this.m_settings.m_stsEndpointOverride) && !StringUtils.isNullOrEmpty(this.m_settings.m_awsRegion)) {
            aWSSecurityTokenServiceClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.m_settings.m_stsEndpointOverride, this.m_settings.m_awsRegion));
        } else if (!StringUtils.isNullOrEmpty(this.m_settings.m_awsRegion)) {
            aWSSecurityTokenServiceClientBuilder.setRegion(this.m_settings.m_awsRegion);
        }
        if (null != this.m_settings.m_proxyHost && !this.m_settings.m_proxyHost.isEmpty()) {
            object = new ClientConfiguration();
            ((ClientConfiguration)object).setProxyHost(this.m_settings.m_proxyHost);
            ((ClientConfiguration)object).setProxyPort(this.m_settings.m_proxyPort);
            ((ClientConfiguration)object).setProxyUsername(this.m_settings.m_proxyUid);
            ((ClientConfiguration)object).setProxyPassword(this.m_settings.m_proxyPwd);
            ((ClientConfiguration)object).setProxyDomain(this.m_settings.m_proxyDomain);
            ((ClientConfiguration)object).setProxyWorkstation(this.m_settings.m_proxyWorkstation);
            ((ClientConfiguration)object).setUserAgent(this.m_settings.m_userAgent);
            aWSSecurityTokenServiceClientBuilder.setClientConfiguration((ClientConfiguration)object);
        }
        object = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)aWSSecurityTokenServiceClientBuilder.withCredentials(aWSCredentialsProvider)).build();
        String string = basicProfile.getRoleArn();
        String string2 = basicProfile.getRoleSessionName();
        if (StringUtils.isNullOrEmpty(string2)) {
            string2 = this.m_settings.m_defaultRoleSessionNamePrefix + System.currentTimeMillis();
        }
        String string3 = basicProfile.getRoleExternalId();
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(string).withRoleSessionName(string2);
        if (!StringUtils.isNullOrEmpty(string3)) {
            assumeRoleRequest = assumeRoleRequest.withExternalId(string3);
        }
        AssumeRoleResult assumeRoleResult = object.assumeRole(assumeRoleRequest);
        Credentials credentials = assumeRoleResult.getCredentials();
        Date date = credentials.getExpiration();
        BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        return CredentialsHolder.newInstance(basicSessionCredentials, date);
    }
}

