/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.amazonaws.services.athena.model.DataCatalogSummary;
import com.simba.athena.athena.AJMetadataRetrievalMethod;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.dataengine.metadata.AJSchemaMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJMetadataHelperUtilities;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AJCatalogSchemaOnlyMetadataSource
implements IMetadataSource {
    private AJClient m_client;
    private ILogger m_logger;
    private List<AJSchemaMetadata> m_schemaList = new ArrayList<AJSchemaMetadata>();
    private ListIterator<AJSchemaMetadata> m_schemaIterator;
    private AJSchemaMetadata m_currentSchema;

    public AJCatalogSchemaOnlyMetadataSource(ILogger iLogger, AJClient aJClient, String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, aJClient);
        this.m_logger = iLogger;
        this.m_client = aJClient;
        if (null == string || string.isEmpty()) {
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_client.getMetadataRetrievalMethod()) {
                List<Object> list = new ArrayList();
                list = this.m_client.getCatalogsWtihProxyApi();
                for (DataCatalogSummary dataCatalogSummary : list) {
                    AJMetadataHelperUtilities.getSchemasWithCatalogCheck(dataCatalogSummary.getCatalogName(), string, this.m_client, this.m_schemaList);
                }
            } else {
                this.m_client.getSchemas("AwsDataCatalog", this.m_schemaList);
            }
        } else if (null == string2 || string2.isEmpty()) {
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_client.getMetadataRetrievalMethod()) {
                this.m_client.getSchemas(string, this.m_schemaList);
            } else {
                this.m_client.getSchemas("AwsDataCatalog", this.m_schemaList);
            }
        } else {
            if (string2.contains("\\")) {
                string2 = string2.replace("\\", "");
            }
            AJSchemaMetadata aJSchemaMetadata = new AJSchemaMetadata(string, string2);
            this.m_schemaList.add(aJSchemaMetadata);
        }
        this.m_schemaIterator = this.m_schemaList.listIterator(0);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentSchema.m_catalogName, dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentSchema.m_schemaName, dataWrapper, l, l2);
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_schemaIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentSchema = this.m_schemaIterator.next();
            return true;
        }
        return false;
    }
}

