/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athena.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.athena.model.AthenaError;

@SdkInternalApi
public class AthenaErrorMarshaller {
    private static final MarshallingInfo<Integer> ERRORCATEGORY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCategory").build();
    private static final MarshallingInfo<Integer> ERRORTYPE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorType").build();
    private static final MarshallingInfo<Boolean> RETRYABLE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Retryable").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final AthenaErrorMarshaller instance = new AthenaErrorMarshaller();

    public static AthenaErrorMarshaller getInstance() {
        return instance;
    }

    public void marshall(AthenaError athenaError, ProtocolMarshaller protocolMarshaller) {
        if (athenaError == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(athenaError.getErrorCategory(), ERRORCATEGORY_BINDING);
            protocolMarshaller.marshall(athenaError.getErrorType(), ERRORTYPE_BINDING);
            protocolMarshaller.marshall(athenaError.getRetryable(), RETRYABLE_BINDING);
            protocolMarshaller.marshall(athenaError.getErrorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

