/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.util;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class TimestampFormat
extends SimpleDateFormat {
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final int FORMAT_LENGTH = "yyyy-MM-dd HH:mm:ss.SSS".length();
    private static final FieldPosition START = new FieldPosition(0);
    private static int vm = -1;
    private StringBuffer buffer = null;
    private NumberFormat nf = null;

    public TimestampFormat() {
        this(false);
    }

    public TimestampFormat(boolean sync) {
        if (vm < 0) {
            vm = TimestampFormat.getVM();
        }
        if (vm >= 4) {
            this.applyPattern(FORMAT);
        } else {
            this.applyPattern("yyyy-MM-dd HH:mm:ss");
            this.nf = new DecimalFormat();
            this.nf.setMaximumIntegerDigits(3);
            this.nf.setMinimumIntegerDigits(3);
            this.nf.setMaximumFractionDigits(0);
            if (sync) {
                this.buffer = new StringBuffer(FORMAT_LENGTH);
            }
        }
        this.setCalendar(Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String format(Timestamp ts) {
        if (vm >= 4) {
            return super.format(ts);
        }
        if (this.buffer == null) {
            StringBuffer stb = new StringBuffer(FORMAT_LENGTH);
            this.format(ts, stb);
            return stb.toString();
        }
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.buffer.delete(0, this.buffer.length());
            this.format(ts, this.buffer);
            return this.buffer.toString();
        }
    }

    private final void format(Timestamp ts, StringBuffer stb) {
        this.format(ts, stb, START).append(".");
        this.nf.format(ts.getNanos() / 1000000, stb, START);
    }

    private static int getVM() {
        String ver = System.getProperty("java.vm.version");
        if (!ver.startsWith("1.")) {
            return 0;
        }
        String subver = ver.substring(2);
        if (subver.length() < 1) {
            return 0;
        }
        vm = Integer.parseInt(subver.substring(0, 1));
        return vm;
    }
}

