/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public final class ListUtil {
    private static final int LONGDIGIT10 = 18;
    private static BigInteger[] m_bigPow10;
    private static NumberFormat CACHE_DECIMAL_FORMAT;
    private static final long CONGNEGD10 = 0xCCCCCCCCCCCCCCCL;
    private static final int GINT = Integer.MAX_VALUE;
    private static final int GNEGI = Integer.MIN_VALUE;
    private static final long[] scaletab;
    private static final char[] tenstab;
    private static final char[] onestab;
    private static Method bigDecimalFomratter;

    public static void readTimestampb(byte[] dat, int off, int len, int[] dt, int[] tm) throws SQLException {
        ListUtil.readDateb(dat, off, len, dt);
        len -= 10;
        if (dat[off += 10] != 32) {
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
        ListUtil.readTimeb(dat, ++off, --len, tm);
    }

    public static int readTimeb(byte[] dat, int off, int len, int[] tm) throws SQLException {
        long[] num = new long[1];
        tm[0] = ListUtil.dblint(ListUtil.parsenumb(dat, off, len, num), num[0]);
        len -= 2;
        if (dat[off += 2] != 58) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        tm[1] = ListUtil.dblint(ListUtil.parsenumb(dat, ++off, --len, num), num[0]);
        len -= 2;
        if (dat[off += 2] != 58) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        tm[2] = ListUtil.dblint(ListUtil.parsenumb(dat, ++off, --len, num), num[0]);
        if (tm[0] < 0 || tm[0] > 23) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        if (tm[1] < 0 || tm[1] > 59) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        if (tm[2] < 0 || tm[2] > 59) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        off += 2;
        if ((len -= 2) > 0) {
            if (dat[off] != 46) {
                throw new SQLException("Invalid Time", "22008", 22008);
            }
            tm[3] = ListUtil.dblint(ListUtil.parsenumb(dat, off, len, num), num[0] * 1000000000L);
        } else {
            tm[3] = 0;
        }
        if (tm[3] > 999999999 || tm[3] < 0) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        return off;
    }

    public static int readDateb(byte[] dat, int off, int len, int[] dt) throws SQLException {
        long[] num = new long[1];
        dt[0] = ListUtil.dblint(ListUtil.parsenumb(dat, off, len, num), num[0]);
        len -= 4;
        if (dat[off += 4] != 45) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        dt[1] = ListUtil.dblint(ListUtil.parsenumb(dat, ++off, --len, num), num[0]);
        len -= 2;
        if (dat[off += 2] != 45) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        dt[2] = ListUtil.dblint(ListUtil.parsenumb(dat, ++off, --len, num), num[0]);
        if (dt[1] < 1 || dt[1] > 12 || dt[1] < 1) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        switch (dt[1]) {
            case 2: {
                if (!(dt[0] % 4 == 0 && dt[0] % 100 != 0 || dt[0] % 400 == 0 ? dt[2] > 29 : dt[2] > 28)) break;
                throw new SQLException("Invalid Date", "22008", 22008);
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (dt[2] <= 31) break;
                throw new SQLException("Invalid Date", "22008", 22008);
            }
            default: {
                if (dt[2] <= 30) break;
                throw new SQLException("Invalid Date", "22008", 22008);
            }
        }
        return off;
    }

    public static String canonizeTimestampString(String s) {
        int dotPos = s.indexOf(46);
        if (dotPos >= 0) {
            int i = s.length() - 1;
            while (s.charAt(i) == '0') {
                --i;
            }
            if (i == dotPos) {
                --i;
            }
            s = s.substring(0, i + 1);
        }
        return s;
    }

    public static String canonizeFloatingPointString(String s) {
        if (s.indexOf(32) > 0) {
            s = s.replaceAll(" ", "");
        }
        return ListUtil.canonizeFloatingPointString(Double.parseDouble(s));
    }

    public static String canonizeFloatingPointString(double value) {
        if (value == 0.0) {
            return "0";
        }
        if (CACHE_DECIMAL_FORMAT == null) {
            ListUtil.initDecimalFormat();
        }
        String str = CACHE_DECIMAL_FORMAT.format(value);
        int len = str.length();
        boolean clipp = false;
        if (str.charAt(len - 1) == '0') {
            --len;
            clipp = true;
        }
        if (str.charAt(len - 1) == '.') {
            --len;
            clipp = true;
        }
        if (clipp) {
            str = str.substring(0, len);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDecimalFormat() {
        Class<ListUtil> clazz = ListUtil.class;
        synchronized (ListUtil.class) {
            if (CACHE_DECIMAL_FORMAT != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            StringBuilder b = new StringBuilder();
            b.append('.');
            for (int i = 0; i < 128; ++i) {
                b.append('#');
            }
            String pattern = b.toString();
            pattern = pattern + ";-" + pattern;
            CACHE_DECIMAL_FORMAT = new DecimalFormat(pattern, new DecimalFormatSymbols(Locale.US));
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String scaledDecimaltoString(int scale, BigInteger intVal) {
        StringBuffer buf;
        if (scale == 0) {
            return intVal.toString();
        }
        String intString = intVal.abs().toString();
        int signum = intVal.signum();
        if (scale > 0) {
            buf = new StringBuffer(intString);
            if (signum < 0) {
                buf.insert(0, '-');
            }
            do {
                buf.append('0');
            } while (--scale > 0);
        } else {
            int insertionPoint;
            int len;
            for (len = intString.length(); len > 0 && scale < 0 && intString.charAt(len - 1) == '0'; --len, ++scale) {
            }
            if (len != intString.length()) {
                if (len == 0) {
                    return "0";
                }
                intString = intString.substring(0, len);
                if (scale == 0) {
                    return signum < 0 ? "-" + intString : intString;
                }
            }
            if ((insertionPoint = len + scale) == 0) {
                return (signum < 0 ? "-." : ".") + intString;
            }
            if (insertionPoint > 0) {
                buf = new StringBuffer(intString);
                buf.insert(insertionPoint, '.');
                if (signum < 0) {
                    buf.insert(0, '-');
                }
            } else {
                buf = new StringBuffer(-scale + 2);
                buf.append(signum < 0 ? "-." : ".");
                for (int i = 0; i < -insertionPoint; ++i) {
                    buf.append('0');
                }
                buf.append(intString);
            }
        }
        return buf.toString();
    }

    public static BigDecimal parsedecb(byte[] dat, int off, int len) throws SQLException {
        long value;
        boolean sign;
        int end;
        BigInteger tmp;
        int scale;
        int decpnt;
        block20: {
            block19: {
                decpnt = 0;
                scale = 0;
                tmp = null;
                end = len += off;
                sign = false;
                while (off < end) {
                    if ((char)(value = (long)(dat[off++] - 48)) <= '\t') break block19;
                    if (value == -3L) {
                        sign = !sign;
                        continue;
                    }
                    if (value == -2L) {
                        decpnt = off;
                        break block19;
                    }
                    if (value == -5L) continue;
                }
                return BigDecimal.valueOf(0L);
            }
            if (value < 1L) {
                while (off < end) {
                    if ((value = (long)(dat[off++] - 48)) == -2L) {
                        if (decpnt != 0) break;
                        decpnt = off;
                        continue;
                    }
                    if (value == 0L) continue;
                    if ((char)value <= '\t') break block20;
                }
                return BigDecimal.valueOf(0L);
            }
        }
        int numDig = 1;
        while (off < end) {
            char digit;
            if ((digit = (char)(dat[off++] - 48)) <= '\t') {
                value = value * 10L + (long)digit;
                if (++numDig != 18) continue;
                tmp = tmp == null ? BigInteger.valueOf(value) : tmp.multiply(m_bigPow10[18]).add(BigInteger.valueOf(value));
                value = 0L;
                numDig = 0;
                continue;
            }
            if ((char)dat[off - 1] == '.') {
                if (decpnt == 0) {
                    decpnt = off;
                    continue;
                }
                end = off - 1;
                break;
            }
            end = off - 1;
            if ((char)dat[off - 1] != 'E' || off >= len) break;
            boolean expsign = false;
            if ((digit = (char)(dat[off++] - 48)) <= '\t') {
                scale = digit;
            } else if ((char)dat[off - 1] == '-') {
                expsign = true;
            } else if ((char)dat[off - 1] != '+') break;
            while (off < len && (digit = (char)(dat[off++] - 48)) <= '\t') {
                if (scale <= 0xCCCCCCC && (scale = scale * 10 + digit) >= 0) continue;
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            if (!expsign) break;
            scale = -scale;
            break;
        }
        if (decpnt != 0) {
            scale -= end - decpnt;
        }
        if (tmp == null) {
            tmp = BigInteger.valueOf(sign ? -value : value);
        } else {
            tmp = tmp.multiply(m_bigPow10[numDig]).add(BigInteger.valueOf(value));
            if (sign) {
                tmp = tmp.negate();
            }
        }
        return scale > 0 ? new BigDecimal(tmp.multiply(scale > 18 ? m_bigPow10[1].pow(scale) : m_bigPow10[scale])) : new BigDecimal(tmp, -scale);
    }

    public static double parsedblb(byte[] dat, int off, int len) throws SQLException {
        char digit;
        boolean sign;
        int end;
        int scale;
        int decpnt;
        block19: {
            block18: {
                decpnt = 0;
                scale = 0;
                end = len += off;
                sign = false;
                while (off < end) {
                    if ((char)((digit = (char)dat[off++]) - 48) <= '\t') break block18;
                    if (digit == '-') {
                        sign = !sign;
                        continue;
                    }
                    if (digit == '.') {
                        decpnt = off;
                        break block18;
                    }
                    if (digit == '+') continue;
                }
                return 0.0;
            }
            if (digit == '0' || digit == '.') {
                while (off < end) {
                    if ((digit = (char)dat[off++]) == '.') {
                        if (decpnt != 0) break;
                        decpnt = off;
                        continue;
                    }
                    if (digit == '0') continue;
                    if ((char)(digit - 48) <= '\t') break block19;
                }
                return 0.0;
            }
        }
        StringBuilder buf = new StringBuilder();
        if (sign) {
            buf.append('-');
        }
        buf.append(digit);
        while (off < end) {
            if ((char)((digit = (char)dat[off++]) - 48) <= '\t') {
                buf.append(digit);
                continue;
            }
            if (digit == '.') {
                if (decpnt == 0) {
                    decpnt = off;
                    continue;
                }
                end = off - 1;
                break;
            }
            end = off - 1;
            if (digit != 'E' && digit != 'e' || off >= len) break;
            boolean expsign = false;
            if ((char)((digit = (char)dat[off++]) - 48) <= '\t') {
                scale = digit - 48;
            } else if (digit == '-') {
                expsign = true;
            } else if (digit != '+') break;
            while (off < len && (digit = (char)(dat[off++] - 48)) <= '\t') {
                if (scale <= 0xCCCCCCC && (scale = scale * 10 + digit) >= 0) continue;
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            if (!expsign) break;
            scale = -scale;
            break;
        }
        if (decpnt != 0) {
            scale -= end - decpnt;
        }
        if (scale != 0) {
            buf.append('E');
            buf.append(scale);
        }
        return Double.parseDouble(buf.toString());
    }

    private static int parsefracb(byte[] dat, int off, int end, long dbl, int dscale, boolean sign, long[] retnum) throws SQLException {
        block0: do {
            char digit;
            if ((digit = (char)(dat[off++] - 48)) > '\t') {
                if (digit != '\u0015' || off >= end) break;
                return ListUtil.parseexpb(dat, off, end, dbl, dscale, sign, retnum);
            }
            if (dbl > 0xCCCCCCCCCCCCCCCL || dbl == 0xCCCCCCCCCCCCCCCL && digit > '\u0007') {
                while (off < end) {
                    if ((digit = (char)(dat[off++] - 48)) <= '\t') continue;
                    if (digit != '\u0015' || off >= end) break block0;
                    return ListUtil.parseexpb(dat, off, end, dbl, dscale, sign, retnum);
                }
                break;
            }
            dbl = dbl * 10L + (long)digit;
            --dscale;
        } while (off < end);
        return ListUtil.scale(dbl, dscale, sign, retnum);
    }

    private static int parseexpb(byte[] dat, int off, int end, long dbl, int dscale, boolean sign, long[] retnum) throws SQLException {
        char digit;
        int exp;
        if (dbl == 0L) {
            retnum[0] = 0L;
            return 0;
        }
        boolean expsign = false;
        if ((char)(exp = dat[off++] - 48) > '\t') {
            if (exp == -3) {
                expsign = true;
            } else if (exp != -5) {
                off = end;
            }
            exp = 0;
        }
        while (off < end && (digit = (char)(dat[off++] - 48)) <= '\t' && exp <= 0xCCCCCCC && (exp = exp * 10 + digit) >= 0) {
        }
        if (exp > 166) {
            if (!expsign) {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            retnum[0] = 0L;
            return 0;
        }
        return ListUtil.scale(dbl, dscale + (expsign ? -exp : exp), sign, retnum);
    }

    public static int parsenumb(byte[] dat, int off, int len, long[] retnum) throws SQLException {
        if (len == 0) {
            retnum[0] = 0L;
            return 0;
        }
        len += off;
        boolean sign = false;
        while (true) {
            int value;
            if ((char)(value = dat[off++] - 48) <= '\t') {
                while (off < len) {
                    char digit;
                    if ((digit = (char)(dat[off++] - 48)) > '\t') {
                        if (off >= len) break;
                        if (digit == '\ufffe') {
                            return ListUtil.parsefracb(dat, off, len, value, 0, sign, retnum);
                        }
                        if (digit != '\u0015') break;
                        return ListUtil.parseexpb(dat, off, len, value, 0, sign, retnum);
                    }
                    if (value >= 0xCCCCCCC) {
                        long dbl = (long)value * 10L + (long)digit;
                        int dscale = 0;
                        while (off < len && (digit = (char)(dat[off++] - 48)) <= '\t') {
                            if (dbl > 0xCCCCCCCCCCCCCCCL || dbl == 0xCCCCCCCCCCCCCCCL && digit > '\u0007') {
                                do {
                                    ++dscale;
                                } while (off < len && (digit = (char)(dat[off++] - 48)) <= '\t');
                                break;
                            }
                            dbl = dbl * 10L + (long)digit;
                        }
                        if (off < len) {
                            if (digit == '\ufffe') {
                                return ListUtil.parsefracb(dat, off, len, dbl, dscale, sign, retnum);
                            }
                            if (digit == '\u0015') {
                                return ListUtil.parseexpb(dat, off, len, dbl, dscale, sign, retnum);
                            }
                        }
                        return ListUtil.scale(dbl, dscale, sign, retnum);
                    }
                    value = value * 10 + digit;
                }
                retnum[0] = sign ? (long)(-value) : (long)value;
                return 0;
            }
            if (off == len) break;
            if (value == -3) {
                sign = !sign;
                continue;
            }
            if (value == -2) {
                return ListUtil.parsefracb(dat, off, len, 0L, 0, sign, retnum);
            }
            if (value != -5) break;
        }
        retnum[0] = 0L;
        return 0;
    }

    private static int scale(long value, int scale, boolean sign, long[] retnum) throws SQLException {
        if (value == 0L) {
            scale = 0;
        } else if (scale > 127) {
            do {
                if (value > 0xCCCCCCCCCCCCCCCL) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                value *= 10L;
            } while (--scale > 127);
        } else if (scale < -128) {
            if (scale < -147) {
                value = 0L;
                scale = 0;
            } else {
                if (value < 0L) {
                    value = 0xCCCCCCCCCCCCCCCL;
                    while (++scale < -128) {
                        value /= 10L;
                    }
                } else {
                    while (++scale < -128 && (value /= 10L) != 0L) {
                    }
                }
                if (value == 0L) {
                    scale = 0;
                }
            }
        }
        retnum[0] = sign ? -value : value;
        return scale;
    }

    public static int dblint(int scale, long num) throws SQLException {
        if (scale < 0) {
            if (scale < -19) {
                return 0;
            }
            if ((num /= scaletab[-scale]) != (long)((int)num)) {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            return (int)num;
        }
        if (num != (long)((int)num)) {
            throw new SQLException("Numeric value out of range", "22003", 22003);
        }
        if (scale > 0 && num != 0L) {
            do {
                if (num > 0xCCCCCCCL) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                if (num < -214748364L) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                num *= 10L;
            } while (--scale != 0);
        }
        return (int)num;
    }

    public static long dbllong(int scale, long num) throws SQLException {
        if (scale < 0) {
            return scale < -19 ? 0L : num / scaletab[-scale];
        }
        if (scale > 0 && num != 0L) {
            do {
                if (num > 0xCCCCCCCCCCCCCCCL) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                if (num < -922337203685477580L) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                num *= 10L;
            } while (--scale != 0);
        }
        return num;
    }

    public static String dblstr(int scale, long num) {
        char[] buf = new char[150];
        boolean negative = num < 0L;
        int end = 150;
        int pos = 150;
        if (num == 0L && scale == 0) {
            return "0";
        }
        if (num == Long.MIN_VALUE) {
            pos = end - 19;
            "9223372036854775808".getChars(0, 19, buf, pos);
        } else {
            int digit;
            int val;
            if (negative) {
                num = -num;
            }
            if ((long)(val = (int)num) == num) {
                do {
                    digit = val % 100;
                    buf[--pos] = onestab[digit];
                    buf[--pos] = tenstab[digit];
                } while ((val /= 100) != 0);
            } else {
                do {
                    digit = (int)(num % 100L);
                    buf[--pos] = onestab[digit];
                    buf[--pos] = tenstab[digit];
                } while ((num /= 100L) != 0L);
            }
            if (buf[pos] == '0') {
                ++pos;
            }
        }
        if (scale > 0) {
            System.arraycopy(buf, pos, buf, 1, end -= pos);
            pos = 1;
            do {
                int n = ++end;
                ++end;
                buf[n] = 48;
            } while (--scale > 0);
        } else if (scale < 0) {
            int len = end - pos;
            if (len > (scale = -scale)) {
                System.arraycopy(buf, pos, buf, pos - 1, len - scale);
                buf[end - scale - 1] = 46;
                --pos;
            } else {
                if ((scale -= len) != 0) {
                    do {
                        buf[--pos] = 48;
                    } while (--scale != 0);
                }
                buf[--pos] = 46;
                buf[--pos] = 48;
            }
        }
        if (negative) {
            buf[--pos] = 45;
        }
        return new String(buf, pos, end - pos);
    }

    public static double dbl2dbl(int scale, long num) {
        char[] buf = new char[32];
        boolean negative = num < 0L;
        int end = 32;
        int pos = 32;
        if (num == 0L) {
            return 0.0;
        }
        if (num == Long.MIN_VALUE) {
            pos = end - 19;
            "9223372036854775808".getChars(0, 19, buf, pos);
        } else {
            if (negative) {
                num = -num;
            }
            while (num > Integer.MAX_VALUE) {
                int digit = (int)(num % 100L);
                buf[--pos] = onestab[digit];
                buf[--pos] = tenstab[digit];
                num /= 100L;
            }
            int val = (int)num;
            do {
                int digit = val % 100;
                buf[--pos] = onestab[digit];
                buf[--pos] = tenstab[digit];
            } while ((val /= 100) != 0);
            if (buf[pos] == '0') {
                ++pos;
            }
        }
        if (negative) {
            buf[--pos] = 45;
        }
        if (scale != 0) {
            System.arraycopy(buf, pos, buf, 0, end -= pos);
            pos = 0;
            buf[end++] = 69;
            if (scale < 0) {
                buf[end++] = 45;
                scale = -scale;
            }
            if (scale >= 100) {
                buf[end++] = 49;
                buf[end++] = tenstab[scale -= 100];
            } else if (scale >= 10) {
                buf[end++] = tenstab[scale];
            }
            buf[end++] = onestab[scale];
        }
        return Double.parseDouble(new String(buf, pos, end - pos));
    }

    public static String lngstr(long num) {
        if ((long)((int)num) == num) {
            return Integer.toString((int)num);
        }
        if (num == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        int pos = 20;
        char[] buf = new char[20];
        if (num < 0L) {
            num = -num;
            do {
                int digit = (int)(num % 100L);
                buf[--pos] = onestab[digit];
                buf[--pos] = tenstab[digit];
            } while ((num /= 100L) != 0L);
            if (buf[pos] != '0') {
                --pos;
            }
            buf[pos] = 45;
        } else {
            do {
                int digit = (int)(num % 100L);
                buf[--pos] = onestab[digit];
                buf[--pos] = tenstab[digit];
            } while ((num /= 100L) != 0L);
            if (buf[pos] == '0') {
                ++pos;
            }
        }
        return new String(buf, pos, 20 - pos);
    }

    public static short dblshort(int scale, long num) throws SQLException {
        int ival = ListUtil.dblint(scale, num);
        if (ival > Short.MAX_VALUE || ival < Short.MIN_VALUE) {
            throw new SQLException("Numeric value out of range", "22003", 22003);
        }
        return (short)ival;
    }

    public static byte dblbyte(int scale, long num) throws SQLException {
        int ival = ListUtil.dblint(scale, num);
        if (ival > 127 || ival < -128) {
            throw new SQLException("Numeric value out of range", "22003", 22003);
        }
        return (byte)ival;
    }

    public static BigDecimal remainingPositiveScale(BigInteger n, int scale) {
        if (scale > 0) {
            n = n.multiply(scale > 18 ? m_bigPow10[1].pow(scale) : m_bigPow10[scale]);
            scale = 0;
        }
        return new BigDecimal(n, -scale);
    }

    public static int readCharacterStream(byte[] utf8, char[] cbuf, int off, int length, int sqlType) throws SQLException {
        String mtemp = null;
        try {
            mtemp = new String(utf8, "UTF-8");
            System.arraycopy(mtemp.toCharArray(), 0, cbuf, off, length);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        return length;
    }

    public static int readAsciiStream(byte[] utf8, byte[] stream, int off, int byteLength, int sqlType) throws SQLException {
        String mtemp = null;
        try {
            mtemp = new String(utf8, "UTF-8");
            utf8 = mtemp.getBytes();
            System.arraycopy(utf8, 0, stream, off, byteLength);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        return byteLength;
    }

    private static int readUnicodeStream(byte[] ucs2bytes, byte[] dest, int destOffset, int srcLen, int destMaxLen, int sqlType) throws SQLException {
        if (sqlType != -1) {
            throw new SQLException("Unsupported type conversion:  only java.sql.Types.LONGVARCHAR or java.sql.Types.VARCHAR can be converted to UnicodeStream", "S1000");
        }
        if (destMaxLen <= 0) {
            destMaxLen = dest.length - destOffset;
        }
        if (destMaxLen <= 0) {
            return 0;
        }
        try {
            return ListUtil.getUTF8Bytes(ucs2bytes, dest, 0, destOffset, srcLen, destMaxLen);
        }
        catch (RuntimeException x) {
            x.printStackTrace();
            throw x;
        }
    }

    public static byte[] getUTF8Bytes(byte[] ucs2bytes, int srcOffset, int srcLen, int destMaxLen) throws SQLException {
        byte[] dest;
        int len;
        int estimated = srcLen / 2 * 3;
        if (destMaxLen > 0 && estimated > destMaxLen) {
            estimated = destMaxLen;
        }
        if ((len = ListUtil.getUTF8Bytes(ucs2bytes, dest = new byte[estimated], srcOffset, 0, srcLen, destMaxLen)) < dest.length) {
            byte[] b = new byte[len];
            System.arraycopy(dest, 0, b, 0, len);
            return b;
        }
        return dest;
    }

    private static int getUTF8Bytes(byte[] ucs2bytes, byte[] dest, int srcOffset, int destOffset, int srcLen, int destMaxLen) throws SQLException {
        int len;
        if (destMaxLen == 0) {
            destMaxLen = -1;
        }
        int totalLen = 0;
        for (int i = 0; i < srcLen && (len = ListUtil.getUTF8single(ucs2bytes, dest, srcOffset + i, destOffset + totalLen, destMaxLen)) >= 1; i += 2) {
            totalLen += len;
            if (destMaxLen < 0) continue;
            destMaxLen -= totalLen;
        }
        return totalLen;
    }

    public static int getUTFBytes(char c, byte[] dest, int destOffset, int destMaxLen) {
        if (destMaxLen == 0) {
            return 0;
        }
        byte b1 = (byte)c;
        byte b2 = (byte)(c >> 8);
        return ListUtil.getUTF8single(b1, b2, dest, destOffset, destMaxLen);
    }

    private static int getUTF8single(byte[] ucs2bytes, byte[] dest, int srcOffset, int destOffset, int destMaxLen) throws SQLException {
        if (destMaxLen == 0) {
            return 0;
        }
        if (srcOffset + 2 >= ucs2bytes.length) {
            throw new SQLException("Bytes are not in UCS format", "S1000");
        }
        byte b1 = ucs2bytes[srcOffset];
        byte b2 = ucs2bytes[srcOffset + 1];
        return ListUtil.getUTF8single(b1, b2, dest, destOffset, destMaxLen);
    }

    public static int getUTF8FromAscii(byte[] src, int srcOffset, byte[] dest, int destOffset, int destMaxLen, String serverLocale) throws IOException {
        byte[] srvb;
        if (destMaxLen == 0) {
            return 0;
        }
        byte b = src[srcOffset];
        if ((b & 0x80) == 0) {
            dest[destOffset] = b;
            return 1;
        }
        if (0 < destMaxLen && destMaxLen < 2) {
            return 0;
        }
        String str = new String(src, srcOffset, 1);
        char c = str.charAt(0);
        if (serverLocale != null && c != '?' && (srvb = str.getBytes(serverLocale))[0] == 63) {
            throw new IOException("8-bit server does not support client encoding: " + c);
        }
        return ListUtil.getUTFBytes(c, dest, destOffset, destMaxLen);
    }

    private static int getUTF8single(byte b1, byte b2, byte[] dest, int destOffset, int destMaxLen) {
        if (destMaxLen == 0) {
            return 0;
        }
        if (b2 == 0 && (b1 & 0x80) == 0) {
            dest[destOffset] = b1;
            return 1;
        }
        if (0 < destMaxLen && destMaxLen < 2) {
            return 0;
        }
        int x = b1 & 0xFF | b2 << 8 & 0xFF00;
        if ((b2 & 0xF8) == 0) {
            int x1 = x >>> 6;
            int x2 = x % 64;
            dest[destOffset] = (byte)(192 + x1);
            dest[destOffset + 1] = (byte)(128 + x2);
            return 2;
        }
        if (0 < destMaxLen && destMaxLen < 3) {
            return 0;
        }
        int x1 = x >>> 12;
        int x2 = (x >>> 6) % 64;
        int x3 = x % 64;
        dest[destOffset] = (byte)(224 + x1);
        dest[destOffset + 1] = (byte)(128 + x2);
        dest[destOffset + 2] = (byte)(128 + x3);
        return 3;
    }

    public static String toString(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return null;
        }
        if (bigDecimalFomratter == null) {
            Class[] argTypes = new Class[]{};
            try {
                bigDecimalFomratter = BigDecimal.class.getMethod("toPlainString", argTypes);
            }
            catch (NoSuchMethodException e) {
                try {
                    bigDecimalFomratter = BigDecimal.class.getMethod("toString", argTypes);
                }
                catch (NoSuchMethodException e1) {
                    throw new NoSuchMethodError(e1.getMessage());
                }
            }
        }
        Object[] args = new Object[]{};
        try {
            return (String)bigDecimalFomratter.invoke((Object)bigDecimal, args);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), "22003", 22003);
        }
    }

    static {
        CACHE_DECIMAL_FORMAT = null;
        m_bigPow10 = new BigInteger[19];
        long v = 1L;
        for (int i = 0; i <= 18; ++i) {
            ListUtil.m_bigPow10[i] = BigInteger.valueOf(v);
            v *= 10L;
        }
        scaletab = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        tenstab = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        onestab = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        bigDecimalFomratter = null;
    }
}

