/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.RealStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class CacheOutputStream
extends OutputStream {
    private RealStream stream;
    private byte[] buffer = null;
    private int currentPosition = 0;
    private int capacity;
    private long streamPosition;
    private boolean closed = false;

    public CacheOutputStream(RealStream s, long pos) {
        this.stream = s;
        this.streamPosition = pos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.stream.closed || this.closed) {
            throw new IOException("This stream object is closed");
        }
        if (this.buffer == null) {
            this.capacity = len;
            this.buffer = new byte[this.capacity];
            System.arraycopy(b, off, this.buffer, 0, len);
            this.currentPosition = len;
        } else if (this.currentPosition + len > this.capacity) {
            this.capacity = this.currentPosition + len;
            byte[] newBuffer = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.currentPosition);
            System.arraycopy(b, off, newBuffer, this.currentPosition, len);
            this.buffer = newBuffer;
            this.currentPosition = this.capacity;
        } else {
            System.arraycopy(b, off, this.buffer, this.currentPosition, len);
            this.currentPosition += len;
        }
        if (this.currentPosition > 10000000) {
            try {
                this.stream.sendBytes(this.streamPosition, this.buffer, 0, this.currentPosition);
                this.streamPosition += (long)this.currentPosition;
                this.currentPosition = 0;
            }
            catch (SQLException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] oba = new byte[]{(byte)b};
        this.write(oba, 0, 1);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.stream.closed || this.closed) {
            throw new IOException("This stream object is closed");
        }
        try {
            this.stream.sendBytes(this.streamPosition, this.buffer, 0, this.currentPosition);
            this.stream.getStreamSize();
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

