/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferRO;
import com.intersys.jdbc.CacheBufferUtils;
import com.intersys.jdbc.CacheList;
import com.intersys.jdbc.CacheListBuilder;
import com.intersys.jdbc.ListItem;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class CacheListReader {
    protected int BUCKET_SIZE = 1024;
    protected String m_locale;
    protected ListItem m_item;

    public CacheListReader(String sLocale) {
        this.m_locale = sLocale;
    }

    public CacheListReader(int iLength, String sLocale) {
        this.m_item = new ListItem(new byte[iLength]);
        this.m_item.listBufferEnd = 0;
        this.m_locale = sLocale;
    }

    public CacheListReader(byte[] buffer, int length, String sLocale) {
        this.m_item = new ListItem(buffer, length);
        this.m_locale = sLocale;
    }

    public CacheListReader(CacheListBuilder list) {
        this.m_item = new ListItem(list.getBuffer(), list.getLength());
        this.m_locale = list.getLocale();
    }

    public void setList(byte[] list) {
        this.m_item = new ListItem(list, list.length);
    }

    public CacheListReader(ListItem li, String loc) {
        this.m_item = li;
        this.m_locale = loc;
    }

    int getOffset() {
        return this.m_item.nextOffset;
    }

    public void next() throws CacheBufferRO.NoMoreDataException {
        try {
            this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        }
        catch (Exception ex) {
            throw new CacheBufferRO.NoMoreDataException();
        }
    }

    public int getOffsetThenNext() throws CacheBufferRO.NoMoreDataException {
        int off = this.m_item.nextOffset;
        this.next();
        return off;
    }

    int getOffsetSkipOne() throws CacheBufferRO.NoMoreDataException {
        this.next();
        return this.m_item.nextOffset;
    }

    void setOffset(int value) {
        this.m_item.nextOffset = value;
    }

    int getEndLength() {
        return this.m_item.listBufferEnd;
    }

    int addToEndLength(int value) {
        return this.m_item.listBufferEnd += value;
    }

    public boolean isEnd() {
        return this.m_item.nextOffset >= this.m_item.listBufferEnd;
    }

    void isEndEx() throws CacheBufferRO.NoMoreDataException {
        if (this.isEnd()) {
            throw new CacheBufferRO.NoMoreDataException();
        }
    }

    public boolean isNull() {
        return this.m_item.isNull;
    }

    public boolean jump(int offset) {
        this.m_item.nextOffset = offset;
        return this.m_item.nextOffset >= this.m_item.listBufferEnd;
    }

    boolean isPastLastItem() {
        return this.m_item.dataOffset >= this.m_item.listBufferEnd;
    }

    public void clearList() {
        this.m_item.listBufferEnd = 0;
        this.m_item.nextOffset = 0;
    }

    public void moveToEnd() {
        this.m_item.nextOffset = this.m_item.listBufferEnd;
    }

    public byte[] getBuffer() {
        return this.m_item.buffer;
    }

    byte[] getTCPBuffer() {
        return this.m_item.buffer;
    }

    public CacheListReader getInnerList() throws SQLException {
        byte[] ba = this.getByteArray();
        if (this.isNull()) {
            return null;
        }
        return new CacheListReader(new ListItem(ba), this.m_locale);
    }

    public boolean getBoolean(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getBoolean(this.m_item);
    }

    public boolean getBoolean() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getBoolean(this.m_item);
    }

    public double getDouble(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getDouble(this.m_item);
    }

    public double getDouble() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getDouble(this.m_item);
    }

    public float getFloat(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getFloat(this.m_item);
    }

    public float getFloat() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getFloat(this.m_item);
    }

    public int getInt(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getInt(this.m_item);
    }

    public int getInt() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getInt(this.m_item);
    }

    public long getLong(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getLong(this.m_item);
    }

    public long getLong() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getLong(this.m_item);
    }

    public short getShort(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getShort(this.m_item);
    }

    public short getShort() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getShort(this.m_item);
    }

    public String getString(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getString(this.m_item, this.m_locale);
    }

    public String getString() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getString(this.m_item, this.m_locale);
    }

    public Time getTime(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getTime(this.m_item);
    }

    public Time getTime() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getTime(this.m_item);
    }

    public Date getDate(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getDate(this.m_item);
    }

    public Date getDate() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getDate(this.m_item);
    }

    public Timestamp getTimestamp(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getTimestamp(this.m_item);
    }

    public Timestamp getTimestamp() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getTimestamp(this.m_item);
    }

    public Date getDate(int offset, Calendar cal) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getDate(this.m_item, cal);
    }

    public Time getTime(int offset, Calendar cal) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getTime(this.m_item, cal);
    }

    public Timestamp getTimestamp(int offset, Calendar cal) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getTimestamp(this.m_item, cal);
    }

    public Date getDate(Calendar cal) throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getDate(this.m_item, cal);
    }

    public Time getTime(Calendar cal) throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getTime(this.m_item, cal);
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getTimestamp(this.m_item, cal);
    }

    public byte[] getBytes(int length) throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getBytes(this.m_item, length);
    }

    public byte[] getRawBytes(int length) throws SQLException {
        this.m_item.dataOffset = this.m_item.nextOffset;
        this.m_item.nextOffset += length;
        return CacheBufferUtils.copyByteArray(this.m_item.buffer, this.m_item.dataOffset, length);
    }

    public byte[] getByteArray(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getByteArray(this.m_item);
    }

    public byte[] getByteArray() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getByteArray(this.m_item);
    }

    public byte getOneByte(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getOneByte(this.m_item);
    }

    public byte getOneByte() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getOneByte(this.m_item);
    }

    public BigInteger getBigInteger() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getBigInteger(this.m_item);
    }

    public BigDecimal getBigDecimal(int offset, int scale) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getBigDecimal(this.m_item, scale);
    }

    public BigDecimal getBigDecimal(int offset) throws SQLException {
        offset = CacheList.getListElement(offset, this.m_item);
        return CacheList.getBigDecimal(this.m_item);
    }

    public BigDecimal getBigDecimal(int scale, boolean hasScale) throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getBigDecimal(this.m_item, scale);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getBigDecimal(this.m_item);
    }

    public BigDecimal getBigDecimalScale(int offset, int scale, int precision, boolean bIgnoreZeroScale) throws SQLException {
        if (-1 == offset) {
            this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        } else {
            offset = CacheList.getListElement(offset, this.m_item);
        }
        BigDecimal bgDec = CacheList.getBigDecimal(this.m_item);
        if (bgDec == null) {
            return null;
        }
        int iMinPrecision = 0;
        BigDecimal tmp = bgDec;
        while (tmp.compareTo(BigDecimal.ONE) >= 0) {
            ++iMinPrecision;
            tmp = tmp.divide(BigDecimal.TEN);
        }
        if (precision > iMinPrecision + scale && precision > bgDec.precision()) {
            MathContext mc = new MathContext(precision);
            bgDec = bgDec.round(mc);
        }
        if (bgDec.scale() > 0) {
            bgDec = bgDec.stripTrailingZeros();
        }
        if (scale > 0 || 0 == scale && bIgnoreZeroScale) {
            BigDecimal ret = bgDec.setScale(scale, 5);
            return ret;
        }
        return bgDec;
    }

    public int getLength() {
        return this.m_item.listBufferEnd;
    }

    public byte getByte() {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        return CacheList.getByte(this.m_item);
    }

    public java.util.Date getUtilDate() throws SQLException {
        String s = this.getString();
        if (s == null) {
            return null;
        }
        return new java.util.Date(Timestamp.valueOf(s).getTime());
    }

    public byte[] getBytesXEP() {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        if (this.m_item.dataLength == 1 && this.m_item.buffer[this.m_item.dataOffset] == 0) {
            return new byte[0];
        }
        return CacheList.getByteArray(this.m_item);
    }

    public final int count() {
        int i = 0;
        while (!this.isEnd()) {
            try {
                this.next();
            }
            catch (CacheBufferRO.NoMoreDataException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.clearList();
        return i;
    }

    public String[] getStringArray() throws SQLException {
        int len = this.count();
        String[] sArray = new String[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getString();
        }
        return sArray;
    }

    public Integer[] getIntWArray() throws SQLException {
        int len = this.count();
        Integer[] sArray = new Integer[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getInt();
        }
        return sArray;
    }

    public int[] getIntArray() throws SQLException {
        int len = this.count();
        int[] sArray = new int[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getInt();
        }
        return sArray;
    }

    public Long[] getLongWArray() throws SQLException {
        int len = this.count();
        Long[] sArray = new Long[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getLong();
        }
        return sArray;
    }

    public long[] getLongArray() throws SQLException {
        int len = this.count();
        long[] sArray = new long[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getLong();
        }
        return sArray;
    }

    public Short[] getShortWArray() throws SQLException {
        int len = this.count();
        Short[] sArray = new Short[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getShort();
        }
        return sArray;
    }

    public short[] getShortArray() throws SQLException {
        int len = this.count();
        short[] sArray = new short[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getShort();
        }
        return sArray;
    }

    public Double[] getDoubleWArray() throws SQLException {
        int len = this.count();
        Double[] sArray = new Double[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getDouble();
        }
        return sArray;
    }

    public double[] getDoubleArray() throws SQLException {
        int len = this.count();
        double[] sArray = new double[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getDouble();
        }
        return sArray;
    }

    public Float[] getFloatWArray() throws SQLException {
        int len = this.count();
        Float[] sArray = new Float[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = Float.valueOf(this.getFloat());
        }
        return sArray;
    }

    public float[] getFloatArray() throws SQLException {
        int len = this.count();
        float[] sArray = new float[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getFloat();
        }
        return sArray;
    }

    public Date[] getDateArray() throws SQLException {
        int len = this.count();
        Date[] sArray = new Date[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getDate();
        }
        return sArray;
    }

    public Time[] getTimeArray() throws SQLException {
        int len = this.count();
        Time[] sArray = new Time[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getTime();
        }
        return sArray;
    }

    public Timestamp[] getTimestampArray() throws SQLException {
        int len = this.count();
        Timestamp[] sArray = new Timestamp[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getTimestamp();
        }
        return sArray;
    }

    public java.util.Date[] getUtilDateArray() throws SQLException {
        int len = this.count();
        java.util.Date[] sArray = new java.util.Date[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getUtilDate();
        }
        return sArray;
    }

    public BigDecimal[] getBigDecimalArray() throws SQLException {
        int len = this.count();
        BigDecimal[] sArray = new BigDecimal[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getBigDecimal();
        }
        return sArray;
    }

    public Boolean[] getBooleanWArray() throws SQLException {
        int len = this.count();
        Boolean[] sArray = new Boolean[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getBoolean();
        }
        return sArray;
    }

    public boolean[] getBooleanArray() throws SQLException {
        int len = this.count();
        boolean[] sArray = new boolean[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getBoolean();
        }
        return sArray;
    }

    public byte[] getByteWArray() {
        int len = this.count();
        byte[] sArray = new byte[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getByte();
        }
        return sArray;
    }

    public Character[] getCharWArray() {
        int len = this.count();
        Character[] sArray = new Character[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = Character.valueOf((char)this.getByte());
        }
        return sArray;
    }

    public String toString() {
        return CacheList.toString(this.m_item.buffer, this.m_item.listBufferEnd, this.m_locale);
    }

    public Object getObject() throws SQLException {
        this.m_item.nextOffset = CacheList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        switch (this.m_item.type) {
            case 1: 
            case 2: {
                return CacheList.getString(this.m_item, this.m_locale);
            }
            case 4: 
            case 5: {
                return CacheList.getLong(this.m_item);
            }
            case 8: {
                return CacheList.getDouble(this.m_item);
            }
        }
        throw new RuntimeException("Invalid type wire.");
    }
}

